#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>

#include "prerr.h"

void
pr_exit(int perr, char *fmt, ...)
{
    int serrno;
    va_list va;
    char msg[128];

    serrno = errno;
    va_start(va, fmt);
    vsnprintf(msg, sizeof msg, fmt, va);
    va_end(va);

    if(perr) {
        /* Not my problem... */
        snprintf(msg + strlen(msg), sizeof msg - strlen(msg), ": %s", strerror(serrno));
    }

    fprintf(stderr, "%s\n", msg);
    exit(EXIT_FAILURE);
}


