/*
compiled and tested with [ DEV-C++ VER 4.9.9.2 ]
tar File structure 
A tar archive interchangeably stores headers and file data. 
Headers are 512 bytes large, followed by zero or more blocks of 512 bytes size each (containing uncompressed file data).
If an archived file has a size in bytes which is not divideable by 512 without rest,
as many bytes as missing to the next 512 byte boundary are added to fill up that last block.
A file that is 513 bytes large thus occupies 512 bytes for the header, 513 bytes for the file's data,
and 511 additional bytes so that the file content will be a multiple of 512 bytes (in this case, 1024 bytes).
Tar was designed for tape devices which can be accessed only a block at a time.
512 bytes (half a kilobyte) was the standard size of a single block. 
*/
//typedef struct
//{
//	char	filename[100];	/*   0  name of next file */
//	char	mode[8];	/* 100  Permissions and type (octal digits) */
//	char	owner[8];	/* 108  Owner ID (ignored) */
//	char	group[8];	/* 116  Group ID (ignored) */
//	char	size[12];	/* 124  Bytes in file (octal digits) */
//	char	mtime[12];	/* 136  Modification time stamp (octal digits)*/
//	char	checksum[8];	/* 148  Header checksum (ignored) */
//	char	type;		/* 156  File type (see below) */
//	char	linkto[100];	/* 157  Linked-to name */
//	char	brand[8];	/* 257  Identifies tar version (ignored) */
//	char	ownername[32];	/* 265  Name of owner (ignored) */
//	char	groupname[32];	/* 297  Name of group (ignored) */
//	char	devmajor[8];	/* 329  Device major number (ignored) */
//	char	defminor[8];	/* 337  Device minor number (ignored) */
//	char	prefix[155];	/* 345  Prefix of name (optional) */
//	char	RESERVED[12];	/* 500  Pad header size to 512 bytes */
//} tar_t; 

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

int hsize=512;       //size of header 
long tarchechecksum(char *header);
main (int argc , char **argv) // usage : hthcsc.exe example.tar
{
char *buffer;     //pointer to temp place for header 
char cs[8],ch;
long int filesize,i;
int checksum;
FILE *filepointer ;
if(argc < 2)  
         {
         printf ("\n===[ HTHCSC : Hamid Tar Header CheckSum Calculator v1.0]===");
         printf ("\nusage :hthcf.exe  example.tar");
         printf ("\ncoded by Hamid Ebadi admin@hamid.ir");
         printf ("\nHamid Network Security Team\n\nhttp://www.hamid.ir");
         getch ();
         return 0;
         }

filepointer=fopen(argv[1],"r");   // open tar file 
buffer = (char*) malloc (hsize);  //allocate memory 
       if (buffer == NULL) exit (2); 
       fread (buffer,1,hsize,filepointer); // just read header 
/* =====================[ Calculate the checksum ]===================== */
checksum=tarchechecksum(buffer); // Calculate the checksum 
       printf ("\ncoded by Hamid Ebadi admin@hamid.ir");
       printf ("\nHamid Network Security Team\n\nhttp://www.hamid.ir");
       printf ("anlizing %s ",argv[1]);
       printf ("\n\nint value of checksum is :%d",checksum);
       itoa(checksum,cs,8); // convert int value of check sum to string (in octal)
       
       printf ("\n\nORIGINAL oct value of checksum is :%s",buffer+148);//read check sum from .tar file
       printf ("\nCORRECT oct value of checksum is :%s",cs); //Calculated Checksum 
       rewind (filepointer);
       printf ("\nfile Extract Path :\n%s",buffer); // showing where tar file extract
       // check if the checksum is correct ?
          if (atoi(buffer+148)==atoi(cs))  printf ("\nthe CheckSum is correct : you dont need to chacnge it (-;");
          else printf ("\nthe CheckSum is NOT correct,use simple HEX EDITOR and change it ( do it yourself )");

free (buffer);
fclose (filepointer);
getch ();
}

/*
The chksum field is the ASCII representation of the octal value of the simple sum of all bytes
in the header record. Each 8-bit byte in the header is added to an unsigned integer, initialized
to zero, the precision of which shall be no less than seventeen bits.
When calculating the checksum, the chksum field is treated as if it were all blanks. 
*/
long tarchechecksum(char *header)
{      long int checksum;
        int i,j;
        // ----- Calculate the checksum
           checksum = 0;
        // Calculate First part of the header
        for (i=0; i<148; i++)
            checksum += header[i];
        // Ignore the checksum value and replace it by ' ' (space)
        for (i=148; i<148+8; i++)
            checksum += ' ';
        // ..... Last part of the header
        for (i=156, j=0; i<hsize; i++, j++)
            checksum += header[i];
        return checksum;
}
 
