/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

/*
typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;
*/



u16 in_cksum(void *data, int len) {
    u32     sum    = 0;
    int     i      = len >> 1,
            endian = 1; // big endian
    u16     crc,
            *p     = (u16 *)data;

    if(*(char *)&endian) endian = 0;
    while(i--) sum += *p++;
    if(len & 1) sum += *p & (endian ? 0xff00 : 0xff);
    crc = sum = (sum >> 16) + (sum & 0xffff);
    if(sum >>= 16) crc += sum;
    if(!endian) crc = (crc >> 8) | (crc << 8);
    return(~crc);
}



int udpspoof(u32 ip_src, u16 port_src, u32 ip_dst, u16 port_dst, u8 *data, int datalen) {
    typedef struct {
        u8      ihl_ver;
        u8      tos;
        u16     tot_len;
        u16     id;
        u16     frag_off;
        u8      ttl;
        u8      protocol;
        u16     check;
        u32     saddr;
        u32     daddr;
    } iph;

    typedef struct {
        u16     source;
        u16     dest;
        u16     len;
        u16     check;
    } udph;

    typedef struct {
        u32     saddr;
        u32     daddr;
        u8      zero;
        u8      protocol;
        u16     len;
    } pseudoh;

    struct  sockaddr_in peer;
    iph     *ip;
    udph    *udp;
    pseudoh *pseudo;
    int     sd,
            on      = 1,
            bytelen;
    u16     fragoff;
    u8      *buff,
            *byte;

#define IPSZ        sizeof(iph)
#define UDPSZ       sizeof(udph)
#define PSEUDOSZ    sizeof(pseudoh)
#define PCKSIZE     (IPSZ + UDPSZ + bytelen)

    buff = malloc(0xffff);
    if(!buff) return(-1);

    ip     = (iph *)buff;
    udp    = (udph *)(buff + IPSZ);
    byte   = (u8 *)(buff + IPSZ + UDPSZ);
    pseudo = (pseudoh *)(buff + IPSZ - PSEUDOSZ);

    sd = socket(AF_INET, SOCK_RAW, IPPROTO_UDP);
    if(sd < 0) return(-1);
    if(setsockopt(sd, IPPROTO_IP, IP_HDRINCL, (void *)&on, sizeof(on))
      < 0) return(-1);

    memcpy(byte, data, datalen);
    bytelen = datalen;

    pseudo->saddr    = ip_src;
    pseudo->daddr    = ip_dst;
    pseudo->zero     = 0;
    pseudo->protocol = IPPROTO_UDP;
    pseudo->len      = htons(UDPSZ + bytelen);

    udp->source      = port_src;
    udp->dest        = port_dst;
    udp->check       = 0;
    udp->len         = pseudo->len;
    udp->check       = htons(in_cksum(pseudo, PSEUDOSZ + UDPSZ + bytelen));

    /*
    Windows doesn't support fragments because it automatically modifies
    the ip->id field so there is no way, as far as I know, to force our ID
    */

    for(fragoff = 0; fragoff < datalen; fragoff += bytelen) {
        bytelen = datalen - fragoff;
        if(bytelen > 1400) bytelen = 1400;
        memcpy(byte, data + fragoff, bytelen);

        ip->ihl_ver  = (4 << 4) | (sizeof(iph) >> 2);
        ip->tos      = 0;
        ip->tot_len  = htons(PCKSIZE);
        ip->id       = htons(1);
        ip->frag_off = htons(fragoff >> 3);
        if((fragoff + bytelen) < datalen) ip->frag_off |= htons(1 << 13);
        ip->ttl      = 128;
        ip->protocol = IPPROTO_UDP;
        ip->check    = 0;
        ip->saddr    = ip_src;
        ip->daddr    = ip_dst;
        ip->check    = htons(in_cksum(ip, IPSZ));

        peer.sin_addr.s_addr = ip_dst;
        peer.sin_port        = port_dst;
        peer.sin_family      = AF_INET;

        printf("- %u bytes [%u total packet]\n", bytelen, PCKSIZE);
        printf("- from %15s : %hu\n",
            inet_ntoa(*(struct in_addr *)&(ip->saddr)), ntohs(udp->source));
        printf("- to   %15s : %hu\n",
            inet_ntoa(peer.sin_addr), ntohs(udp->dest));

        if(sendto(sd, buff, PCKSIZE, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) return(-1);
    }

    close(sd);
    printf("- done\n");
    return(0);

#undef IPSZ
#undef UDPSZ
#undef PSEUDOSZ
#undef PCKSIZE
}


