/*-
 * Copyright (c) 2002, Mike Benham
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of this program nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "log.h"

static void connectionString(int client, int server, char *buf, int length) {
  char clientName[512];
  char serverName[512];

  struct sockaddr_in clientAddr;
  struct sockaddr_in serverAddr;

  int size;

  size = sizeof(clientAddr);
  if (getpeername(client, (struct sockaddr*)&clientAddr, &size) < 0) {
    perror("ASSERT - c getpeername failed.");
    exit(1);
  }

  size = sizeof(serverAddr);
  if (getpeername(server, (struct sockaddr*)&serverAddr, &size) < 0) {
    perror("ASSERT - s getpeername failed.");
    exit(1);
  }

  strcpy(clientName, inet_ntoa(clientAddr.sin_addr));
  strcpy(serverName, inet_ntoa(serverAddr.sin_addr));
  
  snprintf(buf, length, "%s.%d-%s.%d", 
	  clientName, ntohs(clientAddr.sin_port), 
	  serverName, ntohs(serverAddr.sin_port));
}

void LOG_printNotice(int client, int server) {
  char connection[1024];
  connectionString(client, server, connection, sizeof(connection));

  printf("Logging Connection: %s\n", connection);
}

FILE * LOG_init(int client, int server) {
  char fileName[1024];
  connectionString(client, server, fileName, sizeof(fileName));
  return fopen(fileName, "w");
}
