#!/usr/bin/perl

use strict ;
use warnings ;

# perl -I Compress-Raw-Zlib-2.020/blib/lib -I Compress-Raw-Zlib-2.020/blib/arch compress-raw-zlib.pl
use Compress::Raw::Zlib qw(Z_OK Z_DATA_ERROR Z_STREAM_END Z_FINISH MAX_WBITS);

# only fails with this chunksize
my $ChunkSize = 32768;

my $x = new Compress::Raw::Zlib::Inflate(-WindowBits => -MAX_WBITS(), -Bufsize => $ChunkSize)
  or die "Cannot create a inflation stream\n" ;

local *IN;
local *OUT;

open(IN, "ecard.deflated") or die;
open(OUT, "> ecard.inflated") or die;

my $input = '' ;
my ($output, $status) ;

while (read(IN, $input, $ChunkSize)) {
  print "inflating...\n";
  $status = $x->inflate(\$input, $output) ;
  print "done: status: $status\n";
  print OUT $output if ($status == Z_OK or $status == Z_STREAM_END);
  last if $status != Z_OK ;
}

die "inflation failed: $status\n"
  unless $status == Z_STREAM_END ;

close(IN);
close(OUT);
