# CVE-2018-15685 - Electron WebPreferences Remote Code Execution


This is a minimal Electron application with a POC for [CVE-2018-15685](https://nvd.nist.gov/vuln/detail/CVE-2018-15685).

> A remote code execution vulnerability has been discovered affecting apps with the ability to open nested child windows on Electron versions (3.0.0-beta.6, 2.0.7, 1.8.7, and 1.7.15). This vulnerability has been assigned the CVE identifier CVE-2018-15685.

For more information see [my full write up on the Contrast Security blog](https://www.contrastsecurity.com/security-influencers/cve-2018-15685) or the [write up on the offical blog from Electron](https://electronjs.org/blog/web-preferences-fix)

The project contains the fillowing files:

- `main.js` - This is the app's **main process**. Note this has `nodeIntegration` disabled so it should not be possibe use "process"
- `index.html` - This is an example rendered page. This could be remotely controlled URL, or a page from an application with an XSS. In this example even though it is a local file but should not have access to node bindings.

You can learn more about each of these components within the [Quick Start Guide](https://electronjs.org/docs/tutorial/quick-start).

## To Use

To clone and run this repository you'll need [Git](https://git-scm.com) and [Node.js](https://nodejs.org/en/download/) (which comes with [npm](http://npmjs.com)) installed on your computer. From your command line:

```bash
# Clone this repository
git clone https://github.com/matt-/CVE-2018-15685
# Go into the repository
cd CVE-2018-15685
# Install dependencies
npm install
# Run the app
npm start
```
