/*
  Sybase Advantage Server UDP checksums
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <winsock.h>



int __cdecl mysendto(SOCKET s, u_char **retbuf, int len, int flags, const struct sockaddr *to, int tolen) {
    u_char  *buf = *retbuf; // do NOT touch this
    u_int   crc;
    int     i,
            scan;

    if(len < 0x22)  return(len);
    if(len > 0x592) return(len);

    if((buf[1] == '5') || (buf[1] == '7')) {
        for(scan = 0; scan <= 0xffff; scan++) { // scan it
            buf[0x20] = scan;
            buf[0x21] = scan >> 8;

            crc = 0;
            for(i = 0; (i + 2) <= len; i += 2) {
                crc += (buf[i] | (buf[i+1] << 8));
            }
            if(len & 1) crc += buf[i];
            while(crc >> 16) {
                crc = (crc & 0xffff) + (crc >> 16);
            }
            crc = (~crc) & 0xffff;
            if(!crc) break;
        }
    } else {
        crc = 0;
        buf[0x20] = 0;
        buf[0x21] = 0;
        for(i = 0; i < len; i++) crc += buf[i];
        buf[0x20] = crc;
        buf[0x21] = crc >> 8;
    }

    *retbuf = buf;  // do NOT touch this
    return(len);
}



BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved) {
    if(fdwReason == DLL_PROCESS_ATTACH) DisableThreadLibraryCalls(hinstDLL);
    return(TRUE);
}


