import java.applet.*;
import java.lang.*;
import java.io.*;
import java.net.*;

import BOSocket;
import BOServerSocket;
import BOURLConnection;
import BOURLInputStream;

public class BOHTTPD extends Applet implements Runnable {
  String path;
  BOServerSocket ess;
  String host, remote_host;
  int port;
  Thread th;

  public void dump_to(String fn, OutputStream os) throws IOException {
    PrintWriter writer = new PrintWriter(os, true);
    try {
      String fns = fn;

      int i;
      while ((i = fns.indexOf("%20")) >= 0)
        fns = fns.substring(0, i) + " " + fns.substring(i + 3, fns.length());
      while ((i = fns.indexOf("%3a")) >= 0)
        fns = fns.substring(0, i) + ":" + fns.substring(i + 3, fns.length());
      while ((i = fns.indexOf("%3A")) >= 0)
        fns = fns.substring(0, i) + ":" + fns.substring(i + 3, fns.length());
      while ((i = fns.indexOf("%2F")) >= 0)
        fns = fns.substring(0, i) + "/" + fns.substring(i + 3, fns.length());
      while ((i = fns.indexOf("%2f")) >= 0)
        fns = fns.substring(0, i) + "/" + fns.substring(i + 3, fns.length());

      while (fns.length() >= 1 && fns.startsWith("/")) 
        fns = fns.substring(1, fns.length());
      while (fns.length() >= 2 && fns.endsWith("//")) 
        fns = fns.substring(0, fns.length() - 1);

      if (!(fns.startsWith("http:") || fns.startsWith("https:") ||
          fns.startsWith("ftp:") || fns.startsWith("file:"))) 
        fns = "file:/" + fns;
      URL uu = new URL(fns);

      if (fns.equals("file:/")) {
        String s = "Rerouted.\n";
        writer.println("HTTP/1.1 302 Found");
        writer.println("Location: " + "http://" + host + ":" + port + "/" + path);
        writer.println("Content-type: text/plain");
        writer.println("Content-length: " + s.length());
        writer.println("");
        writer.print(s);
        writer.flush();
        return;
      }

      if (fns.startsWith("file:") && !fns.startsWith("file:/" + path) ||
       fns.indexOf("/..") >= 0) {
        String s = "Permission Denied.\n";
        writer.println("HTTP/1.1 403 Permission Denied");
        writer.println("Content-type: text/plain");
        writer.println("Content-length: " + s.length());
        writer.println("");
        writer.print(s);
        writer.flush();
        return;
      }


      BOURLConnection euc;
      BOURLInputStream euis;
      int b, length;

      euc = new BOURLConnection(uu);
      euis = new BOURLInputStream(euc);
      length = 0;
      while ((b = euis.read()) >= 0) length++;
      euis.close();

      String type = BOMimeType.get(fns);

      writer.println("HTTP/1.1 200 OK");
      writer.println("Content-type: " + type);
      writer.println("Content-length: " + length);
      writer.println("");

      if (type == "text/html") {
        String root = "http://www.brumleve.com/BrownOrifice";
        writer.print(
          "<link rel=stylesheet href=\"" + root + "/BOHTTPD.css\">" +
          "<table bgcolor=white width=640>" +
            "<tr valign=top>" +
              "<td><img src=\"" + root + "/BOHTTPD_logo.cgi?" + host + ":" + port + "\"></td>" +
              "<td width=100% align=left>" +
                "<h2>Brown Orifice<br><code>" + fns + "</code></h2>" +
                "<ul>" +
                "<li><a href=\"" + root + "/BOHTTPD.cgi\">Brown Orifice HTTPD Homepage</a>" +
                "<li><a href=\"" + root + "/BOHTTPD_spy.cgi\">BOHTTPD Spy</a>" +
                "<li><a href=\"" + root + "/BOHTTPD_download.cgi\">Download BOHTTPD!</a>" +
                "</ul>" +
              "</td>" +
            "</tr>" +
          "</table><hr>"
        );
      }

      writer.flush();

      euc = new BOURLConnection(uu);
      euis = new BOURLInputStream(euc);
      while ((b = euis.read()) >= 0) os.write(b);
      euis.close();
    } catch (Exception e) {
      String resp = e + "";
      writer.println("HTTP/1.1 500 Internal Server Error");
      writer.println("Content-type: text/plain");
      writer.println("Content-length: " + resp.length());
      writer.println("");
      writer.print(resp);
      writer.flush();
    }
  }

  public String origin() {
    URL appletSource = getDocumentBase();
    try {
      InetAddress host;
      host = InetAddress.getByName(appletSource.getHost());
      return host.getHostName();
    } catch (Exception e) { System.out.println(e); };
    return "localhost";
  }

  public void init() {
    try {
      remote_host = origin();
      path = new String(getParameter("path"));
System.out.println("path=" + path);
      while (path.startsWith("/")) path = path.substring(1, path.length());
      if (!path.endsWith("/")) path += "/";

      host = new String(getParameter("host"));
System.out.println("host=" + host);
      port = new Integer(getParameter("port")).intValue();
System.out.println("port=" + port);
      ess = new BOServerSocket(port);
    } catch (Exception e) { System.out.println(e); }
  }

  public void start() { 
    th = new Thread(this);
    th.start();
  }

  //public void stop() { 
  //  th.stop();
  //}

  public void run() {
    BOSocket client;
    PrintWriter writer;
    BufferedReader reader;
    String line;

    try {
      while (true) {
        client = ess.accept_any();
  
        writer = new PrintWriter(client.getOutputStream(), true);
        reader = new BufferedReader(
          new InputStreamReader(client.getInputStream()));
  
        line = reader.readLine();
        while (reader.readLine().length() > 0) { }
  
        int at0 = line.indexOf(" ");
        if (at0 < 0) throw new IOException();
        int at1 = line.indexOf(" HTTP");
        if (at1 < 0) throw new IOException();
        String filename = line.substring(at0 + 1, at1);

        dump_to(filename, client.getOutputStream());
        client.close_real();
      }
    } catch (Exception e) { System.out.println(e); }
  }
}
  
