import java.util.Hashtable;

class BOMimeType {
  public static Hashtable hash;

  public static void main(String[] argv) {
    for (int i = 0; i < argv.length; i++) {
      System.out.println(argv[i] + " " + get(argv[i]));
    }
  }

  public static String get(String s) {
System.out.println("lookup: [" + s + "]\n");
    if (s.endsWith("/")) return "text/html";
    int at = s.lastIndexOf(".");
    String ext = (at < 0) ? s : s.substring(at + 1);
    String type = (String)hash.get(ext);
    return type == null ? "text/plain" : type;
  }

  static {
    hash = new Hashtable();
    hash.put("ez", "application/andrew-inset");
    hash.put("hqx", "application/mac-binhex40");
    hash.put("cpt", "application/mac-compactpro");
    hash.put("doc", "application/msword");
    hash.put("bin", "application/octet-stream");
    hash.put("dms", "application/octet-stream");
    hash.put("lha", "application/octet-stream");
    hash.put("lzh", "application/octet-stream");
    hash.put("exe", "application/octet-stream");
    hash.put("class", "application/octet-stream");
    hash.put("oda", "application/oda");
    hash.put("pdf", "application/pdf");
    hash.put("ai", "application/postscript");
    hash.put("eps", "application/postscript");
    hash.put("ps", "application/postscript");
    hash.put("rtf", "application/rtf");
    hash.put("smi", "application/smil");
    hash.put("smil", "application/smil");
    hash.put("mif", "application/vnd.mif");
    hash.put("ppt", "application/vnd.ms-powerpoint");
    hash.put("bcpio", "application/x-bcpio");
    hash.put("bz2", "application/x-bzip2");
    hash.put("vcd", "application/x-cdlink");
    hash.put("pgn", "application/x-chess-pgn");
    hash.put("cpio", "application/x-cpio");
    hash.put("csh", "application/x-csh");
    hash.put("dcr", "application/x-director");
    hash.put("dir", "application/x-director");
    hash.put("dxr", "application/x-director");
    hash.put("dvi", "application/x-dvi");
    hash.put("spl", "application/x-futuresplash");
    hash.put("gtar", "application/x-gtar");
    hash.put("gz", "application/x-gzip");
    hash.put("tgz", "application/x-gzip");
    hash.put("hdf", "application/x-hdf");
    hash.put("js", "application/x-javascript");
    hash.put("skp", "application/x-koan");
    hash.put("skd", "application/x-koan");
    hash.put("skt", "application/x-koan");
    hash.put("skm", "application/x-koan");
    hash.put("latex", "application/x-latex");
    hash.put("nc", "application/x-netcdf");
    hash.put("cdf", "application/x-netcdf");
    hash.put("rpm", "application/x-rpm");
    hash.put("sh", "application/x-sh");
    hash.put("shar", "application/x-shar");
    hash.put("swf", "application/x-shockwave-flash");
    hash.put("sit", "application/x-stuffit");
    hash.put("sv4cpio", "application/x-sv4cpio");
    hash.put("sv4crc", "application/x-sv4crc");
    hash.put("tar", "application/x-tar");
    hash.put("tcl", "application/x-tcl");
    hash.put("tex", "application/x-tex");
    hash.put("texinfo", "application/x-texinfo");
    hash.put("texi", "application/x-texinfo");
    hash.put("t", "application/x-troff");
    hash.put("tr", "application/x-troff");
    hash.put("roff", "application/x-troff");
    hash.put("man", "application/x-troff-man");
    hash.put("me", "application/x-troff-me");
    hash.put("ms", "application/x-troff-ms");
    hash.put("ustar", "application/x-ustar");
    hash.put("src", "application/x-wais-source");
    hash.put("zip", "application/zip");
    hash.put("au", "audio/basic");
    hash.put("snd", "audio/basic");
    hash.put("mid", "audio/midi");
    hash.put("midi", "audio/midi");
    hash.put("kar", "audio/midi");
    hash.put("mpga", "audio/mpeg");
    hash.put("mp2", "audio/mpeg");
    hash.put("mp3", "audio/mpeg");
    hash.put("aif", "audio/x-aiff");
    hash.put("aiff", "audio/x-aiff");
    hash.put("aifc", "audio/x-aiff");
    hash.put("ram", "audio/x-pn-realaudio");
    hash.put("rm", "audio/x-pn-realaudio");
    hash.put("ra", "audio/x-realaudio");
    hash.put("wav", "audio/x-wav");
    hash.put("pdb", "chemical/x-pdb");
    hash.put("xyz", "chemical/x-pdb");
    hash.put("gif", "image/gif");
    hash.put("ief", "image/ief");
    hash.put("jpeg", "image/jpeg");
    hash.put("jpg", "image/jpeg");
    hash.put("jpe", "image/jpeg");
    hash.put("png", "image/png");
    hash.put("tiff", "image/tiff");
    hash.put("tif", "image/tiff");
    hash.put("ras", "image/x-cmu-raster");
    hash.put("pnm", "image/x-portable-anymap");
    hash.put("pbm", "image/x-portable-bitmap");
    hash.put("pgm", "image/x-portable-graymap");
    hash.put("ppm", "image/x-portable-pixmap");
    hash.put("rgb", "image/x-rgb");
    hash.put("xbm", "image/x-xbitmap");
    hash.put("xpm", "image/x-xpixmap");
    hash.put("xwd", "image/x-xwindowdump");
    hash.put("igs", "model/iges");
    hash.put("iges", "model/iges");
    hash.put("msh", "model/mesh");
    hash.put("mesh", "model/mesh");
    hash.put("silo", "model/mesh");
    hash.put("wrl", "model/vrml");
    hash.put("vrml", "model/vrml");
    hash.put("css", "text/css");
    hash.put("asc", "text/plain");
    hash.put("txt", "text/plain");
    hash.put("rtx", "text/richtext");
    hash.put("rtf", "text/rtf");
    hash.put("sgml", "text/sgml");
    hash.put("sgm", "text/sgml");
    hash.put("tsv", "text/tab-separated-values");
    hash.put("etx", "text/x-setext");
    hash.put("xml", "text/xml");
    hash.put("mpeg", "video/mpeg");
    hash.put("mpg", "video/mpeg");
    hash.put("mpe", "video/mpeg");
    hash.put("qt", "video/quicktime");
    hash.put("mov", "video/quicktime");
    hash.put("avi", "video/x-msvideo");
    hash.put("movie", "video/x-sgi-movie");
    hash.put("ice", "x-conference/x-cooltalk");
    hash.put("html", "text/html");
    hash.put("htm", "text/html");
  }
}
