// based on the unixjunkie "kernel extension by hand" example from: http://unixjunkie.blogspot.ch/2006/12/kernel-extension-by-hand.html
// gcc -Xlinker -kext -static FakeKext.c -o FakeKext -fno-builtin -nostdlib -lkmod -r -I/System/Library/Frameworks/Kernel.framework/Headers -Wall

#include <libkern/libkern.h>
#include <mach/mach_types.h>

kern_return_t FakeKextStart(kmod_info_t *ki, void *d) {
  printf("Hello from an unsigned kext\n");
  return KERN_SUCCESS;
}

kern_return_t FakeKextStop(kmod_info_t *ki, void *d) {
  printf("Goodbye, World!\n");
  return KERN_SUCCESS;
}

extern kern_return_t _start(kmod_info_t *ki, void *data);
extern kern_return_t _stop(kmod_info_t *ki, void *data);

KMOD_EXPLICIT_DECL(com.foo.FakeKext, "1.0.0d1", _start, _stop)
__private_extern__ kmod_start_func_t *_realmain = FakeKextStart;
__private_extern__ kmod_stop_func_t *_antimain = FakeKextStop;
__private_extern__ int _kext_apple_cc = __APPLE_CC__;
