#!/usr/bin/env python

"""
tool for producing simple binary diffs

output format:
  repeated:
    u32 offset - offset from the start of the file to begin the patch
    u32 length - length of the patch
    u8*        - length bytes to be overwritten with 
"""

import sys
from struct import pack

from binascii import hexlify

def usage():
  print 'python differ.py <original> <patched> <output>'
  print '  produce a diff file between original and patched'
  print '  this tool is for runtime binary patches; therefore'
  print '  the input and output must be the same size'

def pack_patch_entry(offset, diff):
  return pack('<II', offset, len(diff)) + diff

def do_diff(original_bytes, patched_bytes):
  if len(original_bytes) != len(patched_bytes):
    print 'original and patched are different lengths!'
    exit()

  patch = ''

  start = 0
  diff = ''

  for i in xrange(len(original_bytes)):
    o = original_bytes[i]
    p = patched_bytes[i]

    if o != p:
      if len(diff) == 0:
        start = i
      diff += p

    else:
      if len(diff) > 0:
        patch += pack_patch_entry(start, diff)
        diff = ''

  if len(diff) > 0:
    # did we finish still doing a patch?
    patch += pack_patch_entry(start, diff)

  return patch

if __name__ == '__main__':
  if len(sys.argv) < 4:
    usage()
    exit()

  original_path = sys.argv[1]
  patched_path  = sys.argv[2]
  output_path   = sys.argv[3]
  
  original_bytes = open(original_path).read()
  patched_bytes  = open(patched_path).read()

  patch = do_diff(original_bytes, patched_bytes)

  if len(patch) == 0:
    print 'those file are the same...'
    exit(0)

  open(output_path, 'w').write(patch)
