/*
===========================================================================
Copyright (C) 1999-2005 Id Software, Inc.
This file is part of Quake III Arena source code.
Quake III Arena source code is free software; you can redistribute it
and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.
Quake III Arena source code is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
===========================================================================
*/

#pragma once

typedef unsigned char byte;
typedef DWORD _DWORD;
typedef bool qboolean;

#define NYT HMAX                    /* NYT = Not Yet Transmitted */
#define INTERNAL_NODE ( HMAX + 1 )

typedef struct nodetype {
	struct  nodetype *left, *right, *parent; /* tree structure */
											 //	struct  nodetype *next, *prev; /* doubly-linked list */
											 //	struct  nodetype **head; /* highest ranked node in block */
	int weight;
	int symbol; //0x10
				//	struct  nodetype *next, *prev; /* doubly-linked list */
				//	struct  nodetype **head; /* highest ranked node in block */

} node_t; //Length: 20

#define HMAX 256 /* Maximum symbol */

typedef struct {
	int         blocNode;
	int         blocPtrs;

	node_t*     tree;
	node_t*     loc[HMAX + 1];
	node_t**    freelist;

	node_t      nodeList[768];
	node_t*     nodePtrs[768];

} huff_t;
/* size 19476*/

int MSG_ReadBitsCompress(const byte* input, int readsize, byte* outputBuf, int outputBufsize);
int MSG_WriteBitsCompress(char dummy, const byte *datasrc, byte *buffdest, int bytecount);
void Huffman_InitMain();

#define Com_Memcpy memcpy
#define Com_Memset memset
