#from . import fuzzingdb
import sec1httplib.fuzzingdb as fuzzingdb
import sec1httplib.jsonfuzzer as jsonfuzzer
import copy

"""
Module containing fuzzing modules for use with requestbuilder.
"""

class Vuln():
    def __init__(self,title,*args,**kargs):

        # Set some defaults

        self.title = title
        self.group = 0
        self.short_description = "N/A"
        self.description = "N/A"
        self.fuzz_string = "N/A"
        self.multistage_notes = "N/A"
        self.match_pattern = "N/A"
        self.page_length_diff=0

        self.weight = "10"
        self.impact = "1"
        self.short_fuzz_description = "N/A"
        # Maintain request response objects
        self.request = None
        self.response = None


class VulnDB():
    def __init__(self):
        self.vulns = []
    def add_vuln(self,vuln):
        self.vulns.append(vuln)

    def __add__(self,vulnsdb):
        #for vuln in vulnsdb.vulns:
        #    self.vulns.extend(vuln)
        self.vulns.extend(vulnsdb.vulns)
        return self

    def check_vuln_found(self,method,path,param,check_group):
        for vuln in self.vulns:
            #print vuln.method, vuln.url, vuln.fuzzed_param
            if (vuln.method == method) and (vuln.path == path) and (vuln.fuzzed_param == param) and (vuln.group == check_group):
                return True
        return False



class FuzzingToolsMixin(object):
    """
    Mixin Class to add fuzzing functionailty to request objects
    """
    def __init__(self):
        pass



    def fuzz_embedded_json(self,fuzzstr,urlencoded_string,json_param_offset,append=1,replace=0,delim='&'):

        fuzzed_qs_db=[]
        pairs = self.urlencode_to_list(urlencoded_string)
        fuzz_qs = copy.copy(pairs)
     
        if isinstance(fuzzstr,str):

            paramater_value=fuzz_qs[json_param_offset][1]
            if self.is_json(paramater_value):

                json_fuzzed = []
                if append==1:
                    json_fuzzed.extend(jsonfuzzer.JsonFuzzer(fuzz_qs[json_param_offset][1],fuzzstr,append=1,replace=0).get_fuzzcases())
                if replace==1:
                    json_fuzzed.extend(jsonfuzzer.JsonFuzzer(fuzz_qs[json_param_offset][1],fuzzstr,append=0,replace=1).get_fuzzcases())

                for fuzz_case in json_fuzzed:
                    fuzz_qs[json_param_offset] = (fuzz_qs[json_param_offset][0],fuzz_case["param_string"])
                    fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                    fuzz_case["param_string"] = fuzzed
                    fuzzed_qs_db.append(fuzz_case)

        elif isinstance(fuzzstr,list):

            if self.is_json(fuzz_qs[json_param_offset][1]):
                fuzz_qs = copy.deepcopy(pairs)
                json_fuzzed = []
                if append==1:

                    json_fuzzed.extend(jsonfuzzer.JsonFuzzer(fuzz_qs[json_param_offset][1],fuzzstr,append=1,replace=0).get_fuzzcases())
                if replace==1:
                    json_fuzzed.extend(jsonfuzzer.JsonFuzzer(fuzz_qs[json_param_offset][1],fuzzstr,append=0,replace=1).get_fuzzcases())

                for fuzz_batch in json_fuzzed:
                    json_fuzzbatch=[]
                    for fuzz_case in fuzz_batch:
                        fuzz_qs[json_param_offset] = (fuzz_qs[json_param_offset][0], fuzz_case["param_string"])
                        desc = fuzz_case["description"]
                        fuzzed = delim.join(["=".join(x) for x in fuzz_qs])

                        json_fuzzbatch.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[json_param_offset][0]})

                        if json_fuzzbatch not in fuzzed_qs_db:
                            fuzzed_qs_db.append(json_fuzzbatch)
        return fuzzed_qs_db



    def fuzzgen_urlencoded(self,qs,fuzzstr,delim="&",append=1,replace=0,fuzzparamname=0):
        """Takes a urlformencoded style data string (param=data&param2=data2)
        and returns fuzzed variants.

        Automatically detects JSON encoded data and unpacks it for fuzzing.


        Arguments:

        qs              --      The query string data (including form post data)
        delim           --      Delimiter (&) by default
        append          --      Append fuzz string to existing value
        replace         --      replace data with fuzz string
        fuzzparamname   --      Append fuzz string to paramater name as well as data

        """

        # Encode fuzz string
        fuzzstr = self._urlencode(fuzzstr)
        if qs == "":return []

        # Convert param pairs to a list of tuples
        # [(paramname,paramvalue),(paramname2,paramvalue2)]
        pairs = self.urlencode_to_list(qs)
        # List to hold fuzzed version
        fuzzed_qs_db = []

        # Walk the list and fuzz params
        for param in range(len(pairs)):
            fuzz_qs = copy.copy(pairs)
            
            if self.is_json(fuzz_qs[param][1]):
                print "JSON"
                fuzzed_qs_db.extend(self.fuzz_embedded_json(fuzzstr,qs,param,append=append,replace=replace,delim='&'))
                continue

            
            if isinstance(fuzzstr,str):
                if append == 1:
                    fuzz_qs[param] = (fuzz_qs[param][0],fuzz_qs[param][1] + fuzzstr)
                    # back to qs
                    desc = "The fuzz string: %s was appended to the paramater value: %s" %(fuzzstr,fuzz_qs[param][0])
                    fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                    fuzzed_qs_db.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})
                if replace ==1:
                    fuzz_qs[param] = (fuzz_qs[param][0], fuzzstr)
                    # back to qs
                    desc = "The fuzz string: %s was appended to the paramater value: %s" %(fuzzstr,fuzz_qs[param][0])
                    fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                    fuzzed_qs_db.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})

            elif isinstance(fuzzstr,list):
                fuzzcases =[]
                for fuzzcase in fuzzstr:
                    if append == 1:
                        # Refresh this so that we dont keep growing the dict value
                        fuzz_qs = copy.copy(pairs)
                        fuzz_qs[param] = (fuzz_qs[param][0],fuzz_qs[param][1] + fuzzcase)
                        # back to qs
                        desc = "The fuzz string: %s was appended to the paramater value: %s" %(fuzzcase,fuzz_qs[param][0])
                        fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                        fuzzcases.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})
                if fuzzcases:
                    fuzzed_qs_db.append(fuzzcases)
                #else:
                #    print "[i] No fuzz case created"

                fuzzcases =[]
                for fuzzcase in fuzzstr:
                    if replace == 1:
                        # Refresh this so that we dont keep growing the dict value
                        fuzz_qs = copy.copy(pairs)
                        fuzz_qs[param] = (fuzz_qs[param][0], fuzzcase)
                        # back to qs
                        desc = "The fuzz string: %s was appended to the paramater value: %s" %(fuzzcase,fuzz_qs[param][0])
                        fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                        fuzzcases.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})
                if fuzzcases:
                    fuzzed_qs_db.append(fuzzcases)

            if fuzzparamname==1:
                # No JSON Checking here
                fuzz_qs = copy.copy(pairs)
                if isinstance(fuzzstr,str):
                    fuzz_qs[param] = (fuzz_qs[param][0] + fuzzstr,fuzz_qs[param][1])
                    # back to qs
                    desc = "The fuzz string: %s was appended to the paramater name: %s" %(fuzzstr,fuzz_qs[param][0])
                    fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                    fuzzed_qs_db.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})
                elif isinstance(fuzzstr,list):
                    fuzzcases =[]
                    for fuzzcase in fuzzstr:
                        fuzz_qs = copy.copy(pairs)
                        fuzz_qs[param] = (fuzz_qs[param][0] + fuzzcase,fuzz_qs[param][1])
                        # back to qs
                        desc = "The fuzz string: %s was appended to the paramater name: %s" %(fuzzcase,fuzz_qs[param][0])
                        fuzzed = delim.join(["=".join(x) for x in fuzz_qs])
                        fuzzcases.append({"param_string":fuzzed,"description":desc,"fuzzed_param":fuzz_qs[param][0]})
                    fuzzed_qs_db.append(fuzzcases)
        #print "returning", fuzzed_qs_db
        return fuzzed_qs_db








    def fuzzgen_querystring(self,fuzzstr,delim="&",append=1,replace=0,fuzzparamname=0):
        """Fuzz query string paramaters

        If a string is passed as the fuzzstr it is embedded at each fuzz point and list
        of pre-fuzzed request objects is returned.

        If a list() of fuzz strings is passed then each fuzz case in the list is
        at each position. Passing a list of fuzz strings is typical when performing
        Blind SQL injection testing.

        Each entry within the returned list is a list of request objects since
        there are multiple fuzz strings to apply at each position.

        For example, if the URL to fuzz is http://target/news.asp?id=10&order=1

        Sending a fuzz string of "<attack>" results in a lisy of request objects being
        returned:
        [http://target/news.asp?id=10<attack>order=1,http://target/news.asp?id=10order=1<attack1>

        Sending in a list of ["<attack1>","<attack2>] would result in a list

        [
            [http://target/news.asp?id=10<attack1>order=1,http://target/news.asp?id=10<attack2>order=1],
            [http://target/news.asp?id=10order=1<attack1>,http://target/news.asp?id=10order=1<attack2>]
        ]


        """

        if "?" not in self.url:
            return [self]
        qs = self._get_querystring()
        fuzzed_qs_db = self.fuzzgen_urlencoded(qs,fuzzstr,delim,append,replace,fuzzparamname)
        fuzz_queue =[]
        for qs in fuzzed_qs_db:
            if "?" in self.url:
                try:
                    uri,qstring = self.url.split("?")

                    if isinstance(qs,dict):
                        uri = uri+"?"+ qs["param_string"]
                        # build a new
                        f = copy.deepcopy(self)
                        f.url = uri
                        f.fuzz_notes = qs["description"]
                        f.fuzzed_param = qs["fuzzed_param"]
                        fuzz_queue.append(f)
                    else:
                        request_queue =[]
                        for fuzzdict in qs:
                            uri,qstring = self.url.split("?")
                            uri = uri+"?"+ fuzzdict["param_string"]
                            # build a new
                            f = copy.deepcopy(self)
                            f.url = uri
                            f.fuzz_notes = fuzzdict["description"]
                            f.fuzzed_param = fuzzdict["fuzzed_param"]
                            request_queue.append(f)
                        fuzz_queue.append(request_queue)

                except Exception as err:
                    print err
        return fuzz_queue


    
    def fuzzgen_postdata(self,fuzzstr,delim="&",append=1,replace=0,fuzzparamname=0):
        """Generate POST Data Fuzz cases

        If a string is passed as the fuzzstr it is embedded at each fuzz point and
        a list of pre-fuzzed request objects is returned.

        If a list() of fuzz strings is passed then each fuzz case in the list is
        inserted at each position. Passing a list of fuzz strings is typical when
        performing Blind SQL injection testing.

        Each entry within the returned list is a list of request objects since
        there are multiple fuzz strings to apply at each position.

        For examples see fuzzgen_querystring() notes

        """

        postdata = self.postdata

        if self.content_type.lower() == "application/x-www-form-urlencoded":
            fuzzed_qs_db = self.fuzzgen_urlencoded(postdata,fuzzstr,delim,append,replace,fuzzparamname)
        elif (self.content_type.lower() == "application/json") or (self.content_type.lower() == "text/json"):
            json = jsonfuzzer.JsonFuzzer(postdata,fuzzstr,append=append,replace=replace)
            fuzzed_qs_db = json.get_fuzzcases()
            #print fuzzed_qs_db

        fuzz_queue =[]
        if len(fuzzed_qs_db) < 1:
            # print "[i] No fuzz cases possible"
            # Must have recieved a request that is not fuzzable
            return [self]
        for qs in fuzzed_qs_db:
            if isinstance(qs,dict):
                # Making a deepcopy instead of a new object so we
                # keep all headers etc
                f = copy.deepcopy(self)
                f.fuzz_notes = qs["description"]
                f.postdata=qs["param_string"]
                f.fuzzed_param = qs["fuzzed_param"]
                fuzz_queue.append(f)
            elif isinstance(qs,list):
                request_queue =[]
                for fuzzcase in qs:
                    
                    # Making a deepcopy instead of a new object so we
                    # keep all headers etc
                    f = copy.deepcopy(self)
                    f.fuzz_notes = fuzzcase["description"]
                    f.postdata=fuzzcase["param_string"]
                    f.fuzzed_param = fuzzcase["fuzzed_param"]
                    request_queue.append(f)
                fuzz_queue.append(request_queue)
        return fuzz_queue

    def fuzz_datafinder(self,matchdata,regex=1,look_in="mainbody|mainheaders|redirectbody|redirectheaders"):
        self.data_match_db = []
        for response in self.request_history:
            for findresult in response.find_data(matchdata,regex,look_in=look_in):
                # If this object includes multiple requests then flag it within
                # multistage_notes

                # Determine if this  is a single request or a multistage form
                if self.get_queuelen() > 1:
                    q = ""
                    for r in self.return_request_queue_list():
                        q += "Method:{1} URL: {0}\n".format(r["url"],r["method"])
                    ms = "This is a request is part of a {0} part multi-stage process. ".format(len(self))
                    ms +="The vulnerability was identified at position {0} in the queue".format(self.fuzz_pos+1)
                    ms +="Request Queue:\n\n{0}".format(q)
                    ms = {"multistage_notes":ms}
                else:
                    ms = {"multistage_notes":"Single Fuzz Case"}

                # Check to see if we are executing this on the request or response
                # object and adjust accoringly
                from sec1httplib.requestbuilder import Requestobj,Responseobj
                if isinstance(self,Requestobj):
                    request = self
                elif isinstance(self,Responseobj):
                    request = self.request
                #print type(self)

                datamatch = {"fuzz_notes":self.fuzz_notes,
                            "pattern_found_in": findresult["found_in"],
                            "pattern_found_in_url":findresult["url"],
                            "url":findresult["url"],
                            "pattern":matchdata,
                            "searched_data" : findresult["searched_data"],
                            "request":request}

                # Add multistage info
                datamatch.update(ms)
                self.data_match_db.append(datamatch)
        return self.data_match_db

def initialiseQueue(requests,active_request_index=0):
    """Accepts a list of requests and links then in a multi-stage process.

    Arguments:

    requests        --      A python list of request objects
    active_request  --      Sets the request you want to work on in the queue

    """
    queue = requests[0:len(requests)+1]
    import copy
    active_request = copy.deepcopy(requests[active_request_index])
    # flag to see what side of active request we are at
    exitq = 0
    for multiform in queue:
        if active_request_index == queue.index(multiform):
            active_request.fuzz_pos = queue.index(multiform)
            exitq = 1
        elif multiform is not active_request and exitq == 0:
            active_request.add_prerequest(multiform)
        elif multiform is not active_request and exitq == 1:
            active_request.add_exitrequest(multiform)
        else:
            pass
    return active_request




# step though multiform and fuzz each form
# fuzz each form and continue to the end
# For example a 5 step form would work out:
#[1, 2, 3, 4, 5] fuzz 1
#[1, 2, 3, 4, 5] fuzz 2
#[1, 2, 3, 4, 5] fuzz 3
#[1, 2, 3, 4, 5] fuzz 4
#[1, 2, 3, 4, 5] fuzz 5

def signatureFuzz(requests,fuzzpattern,matchdata,
                    regex=1,startat_index=0,append=1,
                    replace=0,fuzzparamname=0,
                    discovered_vulns_db = VulnDB(),check_group=0,
                    look_in="mainbody|mainheaders|redirectbody|redirectheaders"):

    """
    Signature fuzzer with multistage forms support.
    Paramaters are as follows:
    requests:       A single request or multiple requests to make up a multi-stage process
    fuzzpattern:    A fuzz string
    matchdata:      A regex to positivley match a vulnerabiltiy.
    regex:          1=Regex | 0=String
    startat_index:  For multistage process testing to skip a number of stages
    """

    fuzz_match_list = []

    for x in range(startat_index,len(requests)):
        import copy
        fuzzrequest=initialiseQueue(requests,x)
        
        #If the request is a GET then only fuzz query strings
        #else if we have a POST then fuzz query strings and Form data
        if fuzzrequest.method == "GET":
            fuzzq = fuzzrequest.fuzzgen_querystring(fuzzpattern,append=append,replace=replace,fuzzparamname=fuzzparamname)
        else:
            fuzzq_qs = fuzzrequest.fuzzgen_querystring(fuzzpattern,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq = fuzzrequest.fuzzgen_postdata(fuzzpattern,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq.extend(fuzzq_qs)

        for fuzz in fuzzq:

            # Check to see if we have already found a vuln of this type
            if check_group != 0 and discovered_vulns_db.check_vuln_found(fuzz.method,fuzz.path,fuzz.fuzzed_param,check_group):
                continue

            print "[i] Signature Fuzz request: %s" % fuzz.method,fuzz.url,fuzz.fuzzed_param

            response = fuzz.makerequest()
            response.fuzz_notes = fuzz.fuzz_notes
            #print "Length:%s" % fuzz.get_total_responselength()
            #print "Request Time:%s" % response.request_time

            # We access the fuzz_datafinder via the request rather than the
            # response so we can get request data
            x = fuzz.fuzz_datafinder(matchdata,regex,look_in=look_in)
            fuzz_match_list.extend(x)

    return fuzz_match_list



def calcDifference(a,b):
    if a > b:
        #print a,b
        return a - b
    elif b > a:
        #print b,a
        return b - a
    else:
        return 0

def checkDBForVuln(check_group,fuzzrequest,discovered_vulns_db):
    "Check to see if we have already found this issue"
    try:
        if type(fuzzrequest) == type(list()):
            if check_group != 0 and discovered_vulns_db.check_vuln_found(fuzzrequest[0].method,fuzzrequest[0].path,fuzzrequest[0].fuzzed_param,check_group):
                return True
            if check_group != 0 and discovered_vulns_db.check_vuln_found(fuzzrequest.method,fuzzrequest.path,fuzzrequest.fuzzed_param,check_group):
                return True
        return False
    except:
        return False



def inferenceFuzzPageLength(requests,fuzzpattern_list,
                    startat_index=0,append=1,
                    replace=0,fuzzparamname=0,
                    discovered_vulns_db = VulnDB(),check_group=0,minimum_pagelen_diff=500):
    vulns = []
    diffThreshold = 0

    for x in range(startat_index,len(requests)):
        fuzzrequest=initialiseQueue(requests,x)

        if fuzzrequest.method == "GET":
            fuzzq = fuzzrequest.fuzzgen_querystring(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)
            
        else:
            fuzzq_qs = fuzzrequest.fuzzgen_querystring(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq = fuzzrequest.fuzzgen_postdata(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq.extend(fuzzq_qs)

        # A fuzzbatch is a list of fuzz instances for each inference test.
        # E.g. there could be two requests with a fuzzed param of 1=1 and one
        # with 1=2

        for fuzzbatch in fuzzq:
            bucket = []
            # Check to see if we have already found a vuln of this type

            #if check_group != 0 and discovered_vulns_db.check_vuln_found(fuzzbatch[0].method,fuzzbatch[0].path,fuzzbatch[0].fuzzed_param,check_group):
            #    continue
            if checkDBForVuln(check_group,fuzzbatch,discovered_vulns_db):
                continue

            if isinstance(fuzzbatch,list) and (len(fuzzbatch) > 1):
                for fuzz in fuzzbatch:
                    
                    if not diffThreshold:
                        # Get the maximum page length difference
                        queue_copy = copy.deepcopy(requests)
                        lentest=initialiseQueue(queue_copy,0)
                        compare_length = lentest.makerequest().get_total_responselength()
                        for i in range(1,3):
                            queue_copy = copy.deepcopy(requests)
                            lentest=initialiseQueue(queue_copy,0)
                            
                            result = lentest.makerequest()
                            observed_diff = calcDifference(compare_length,result.get_total_responselength())
                      
                            if  observed_diff  > diffThreshold:
                                diffThreshold = observed_diff
                            elif diffThreshold==0:
                                diffThreshold=1
                                
                    print "[i] Inference Fuzz / Page Length request: %s" % fuzz.method,fuzz.url,fuzz.fuzzed_param
                    fuzz.makerequest()
                    bucket.append(fuzz)
                # send gthe bucket with the result of each fuzzed request to
                # be checked.
                #diffThreshold = (diffThreshold + minimum_pagelen_diff)
                vuln = checkFuzzLenDiff(bucket,minimum_pagelen_diff)
                if vuln:
                    vulns.extend(vuln)

                #vulns.extend(fuzzLenDiff(bucket))
            else:
                # If we have no fuzz cases just execute it.
                print fuzzbatch
                fuzzbatch.makerequest()
                continue
            
    return vulns



def inferenceFuzzTimeDelay(requests,fuzzpattern_list,
                    startat_index=0,append=1,
                    replace=0,fuzzparamname=0,
                    discovered_vulns_db = VulnDB(),check_group=0,expectedDelay=10):
    vulns = []
    for x in range(startat_index,len(requests)):
        fuzzrequest=initialiseQueue(requests,x)

        if fuzzrequest.method == "GET":
            fuzzq = fuzzrequest.fuzzgen_querystring(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)

        else:
            fuzzq_qs = fuzzrequest.fuzzgen_querystring(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq = fuzzrequest.fuzzgen_postdata(fuzzpattern_list,append=append,replace=replace,fuzzparamname=fuzzparamname)
            fuzzq.extend(fuzzq_qs)

        for fuzz in fuzzq:

            # Check to see if we have already found a vuln of this type
            if check_group != 0 and discovered_vulns_db.check_vuln_found(fuzz.method,fuzz.path,fuzz.fuzzed_param,check_group):
                continue

            print "[i] Inference Fuzz / Time Delay request: %s" % fuzz.method,fuzz.url,fuzz.fuzzed_param
            response = fuzz.makerequest()
            response.fuzz_notes = fuzz.fuzz_notes

            # We access the fuzz_datafinder via the request rather than the
            # response so we can get request data
            fuzz.makerequest()
            x = checkFuzzTimeDiff(fuzz,expectedDelay)
            vulns.extend(x)

    return vulns



def checkFuzzLenDiff(fuzzBucket,diffThreshold=10):
    vulns = []
    lengths = []
    for fuzzcase in fuzzBucket:
        lengths.append(int(fuzzcase.get_total_responselength()))
    lengths.sort()
    diff = lengths[-1] - lengths[0]


    if len(fuzzcase) > 1:
        q = ""
        for r in fuzzcase.return_request_queue_list():
            q += "Method:{1} URL: {0}\n".format(r["url"],r["method"])
        ms = "This is a request is part of a {0} part multi-stage process. ".format(len(fuzzcase))
        ms +="The vulnerability was identified at position {0} in the queue".format(fuzzcase.fuzz_pos+1)
        ms +="Request Queue:\n\n{0}".format(q)
        ms = {"multistage_notes":ms}
    else:
        ms = {"multistage_notes":"Single Fuzz Case"}
    #print diff
    if diff > diffThreshold:
        print "[VULN] Vuln found in %s. %s. A page length diff of %s was triggered" % (fuzzcase.url,fuzzcase.fuzz_notes,diff)
        fuzznotes = fuzzcase.fuzz_notes + "\nA page length difference of %s was triggered" % diff
        vuln = {"url":fuzzcase.url,
                "fuzz_notes":fuzznotes,
                "request_type":fuzzcase.method,
                "length_diff":diff,
                "request":fuzzcase}
        vuln.update(ms)
        vulns.append(vuln)
    return vulns



def checkFuzzTimeDiff(fuzzcase,expectedDiff=10):
    vulns = []
    #print fuzzcase.get_response_times()
    for time_dict in fuzzcase.get_response_times():
        #print "[i] Comparing %s with %s" % (time_dict["response_time"],expectedDiff)
        if time_dict["response_time"] >= int(expectedDiff):
            #print "TIME",time_dict["response_time"]
            if len(fuzzcase) > 1:
                q = ""
                for r in fuzzcase.return_request_queue_list():
                    q += "Method:{1} URL: {0}\n".format(r["url"],r["method"])
                ms = "This is a request is part of a {0} part multi-stage process. ".format(len(fuzzcase))
                ms +="The vulnerability was identified at position {0} in the queue".format(fuzzcase.fuzz_pos+1)
                ms +="Request Queue:\n\n{0}".format(q)
                ms = {"multistage_notes":ms}
            else:
                ms = {"multistage_notes":"Single Fuzz Case"}
                 
            vuln = {"url":fuzzcase.url,
                    "fuzz_notes":fuzzcase.fuzz_notes,
                    "request_type":fuzzcase.method,
                    "length_diff":"N/A",
                    "response_time":time_dict["response_time"],
                    "request":fuzzcase}
            print "vuln found"
            vuln.update(ms)
            vulns.append(vuln)
    return vulns





def executeChecksFromDB(request_queue,appcheck_xml,fuzzparamname=1,execute_function_between_checks=None):
    """
    Load appcheck database and perform a signature fuzz
    """
    db = fuzzingdb.AppcheckDB(appcheck_xml)
    resultsdb = VulnDB()

    for check in db.checks:
        for sig in check.signatures:

            # Do we have a regex or a string
            if sig["match_type"] == "regex":
                regex = 1
            else:
                regex = 0

            # Should we append or replace the origional value
            if sig["append_or_replace"] == "A":
                append = 1
                replace = 0
            elif sig["append_or_replace"] == "R":
                append = 0
                replace = 1

            # Before we fuzz do we need to execute a function.
            # e.g. trigger a random time delay
            if execute_function_between_checks:
                execute_function_between_checks()
                
            if sig["fuzz_type"] == "pattern_match":
                # execute signature fuzz with each check from the database
                results =   signatureFuzz(request_queue,
                        sig["fuzz_string"],
                        sig["match_pattern"],
                        regex=regex,
                        startat_index=0,
                        append=append,
                        replace=replace,
                        fuzzparamname=fuzzparamname,
                        discovered_vulns_db=resultsdb,
                        check_group = check.group,
                        look_in = sig["look_in"])

            elif sig["fuzz_type"] == "blind_time":
                results =   inferenceFuzzTimeDelay(request_queue,
                        sig["fuzz_string"],
                        startat_index=0,
                        append=append,
                        replace=replace,
                        fuzzparamname=fuzzparamname,
                        discovered_vulns_db=resultsdb,
                        check_group = check.group,
                        expectedDelay=sig["injected_time_delay"])

            elif sig["fuzz_type"] == "blind_pagelen":

                sig["fuzz_string"] = [sig["fuzz_string1"],sig["fuzz_string2"]]
           
                results =   inferenceFuzzPageLength(request_queue,
                        sig["fuzz_string"],
                        startat_index=0,
                        append=append,
                        replace=replace,
                        fuzzparamname=fuzzparamname,
                        discovered_vulns_db=resultsdb,
                        check_group = check.group)

            else:
                print sig["fuzz_type"]
                results = []

            for result in results:
                v = Vuln(check.title)
                v.group = check.group
                v.short_description = check.short_description
                v.description = check.description
                v.fuzz_string = sig["fuzz_string"]
                #v.fuzz_string1 = sig["fuzz_string1"]
                #v.fuzz_string1 = sig["fuzz_string2"]
                v.multistage_notes = result["multistage_notes"]
                v.fuzz_notes = result["request"].fuzz_notes
                v.match_pattern = sig["match_pattern"]
                v.weight = sig["weight"]
                v.impact = sig["impact"]
                v.short_fuzz_description = sig["short_fuzz_description"]

                # Grab the fuzzed request param from datafinder results
                v.fuzzed_param = result["request"].fuzzed_param
                v.method = result["request"].method
                v.url = result["request"].url
                v.path = result["request"].path
                v.analysis_results = result
                resultsdb.add_vuln(v)
    return resultsdb