import copy
import json
import urllib
import re

class JsonFuzzer():
    """Class to generate fuzz cases from json data parsed using pythons json.loads() function

    Code parses JSON data and unpacks it into python objects.
    The fuzz_pyjason() function walks the structure inserting
    fuzz data within each string or int value. Int values are
    converted to strings to encorporate our fuzzed data without
    breaking the JSON structure.
    """
    # The two functions fuzz_pyjason and _fuzz_list are responsible for walking
    # the structure.
    # 
    # Furthermore, we need a way of sending in single fuzz cases for fuzz->err
    # style testing and we also need to support batches of tests for inference
    # testing (e.g. 1=1 vs 1=2). This also clouds whats going on a bit when trying
    # to read the code.
    #
    # Overall process is.
    # Parse top level dict()
    #       |
    #       V
    #   encounter embedded dict() -> pass back to the function recursivley to unpack it.
    #       |
    #       V
    #   encounter emedded list() -> pass to _fuzz_list().
    #                                   |
    #                                   V
    #                           encounter embedded dict() -> pass to fuzz_pyjason() to unpack and fuzz
    #                                   |
    #                                   V
    #                           encounter emedded list() -> pass to _fuzz_list() recursivley

    def __init__(self,jsonstr,fuzzstr,append=1,replace=0):
        """Parse and fuzz JSON data.

        Arguments:

        jsonstr     --      The JSON string you would like to fuzz
        fuzzstr     --      The fuzz string or python list containing fuzz strings to apply at each position
        append      --      Append the fuzz string to existing data when set to 1 (Default: 1)
        replace     --      Replace the existing data with the fuzz string when set to 1 (Default: 0)

        """

        self.fuzzstr = fuzzstr
        self.fuzzed_json=""

        self.append = append
        self.replace = replace

        url_encoded_json = re.compile("^%5B.+%5D$|^%7B.+%7D$",re.IGNORECASE)
        if re.match(url_encoded_json,jsonstr):
            jsonstr = urllib.unquote(jsonstr)
            self.urlencoded = 1
        else:
            self.urlencoded = 0

        try:
            json_decoded = json.loads(jsonstr)
            if self.append == self.replace:
                print "[NOTE] Setting both append and replace may produce undesired results"
            self.fuzzed_json = self.fuzz_pyjason(json_decoded)
            #if self.append != self.replace:
            #    self.fuzzed_json = self.fuzz_pyjason(json_decoded)
            #else:
            #    print "[Error] Choose either append or replace not both"
        except Exception as err:
            print "[Error] {0}".format(err)


    def get_fuzzcases(self):
        """Return fuzz cases within a python list. Each list entry will be
        either a python dict in the case of single fuzz cases, or a list
        (containing dict()'s) where multiple fuzz strings were provided
        within a list.

        The returned python dict for each fuzz case has the following keys:

        param_string        --      The fuzzed JSON data
        
        fuzzed_param        --      A string showing what part of the JSON data
                                    was fuzzed. Used for compatability reasons.

        description         --      A description of the fuzz case. Used for
                                    compatability reasons

        """
        
        fuzzcases=[]
        for case in self.fuzzed_json:

            if (type(case) == type([])) and (type(self.fuzzstr) == type([])):
                batch=[]
                for fuzzcase in case:
                    description = "The fuzz case was applied within the JSON post data."
                    description = description + json.dumps(fuzzcase)
                    fuzzed_json = json.dumps(fuzzcase)
                    if self.urlencoded:
                        fuzzed_json = urllib.quote(fuzzed_json)
                    batch.append({"param_string":fuzzed_json,"description":description,"fuzzed_param":json.dumps(fuzzcase)})

                fuzzcases.append(batch)
            else:
                description = "The fuzz case was applied within the JSON post data."
                description = description + json.dumps(case)
                fuzzed_json = json.dumps(case)
                
                if self.urlencoded:
                    fuzzed_json = urllib.quote(fuzzed_json)

                fuzzcases.append({"param_string":fuzzed_json,"description":description,"fuzzed_param":json.dumps(case)})
        
        return fuzzcases

        
    def _fuzz_list(self,listobj):
        "This function is invoked if we encounter a list within the python parsed JSON"
        fuzzed_db = []
        for list_item in listobj:

            # If we encounter a string within the list
            #if (type(list_item) == type("")) or (type(list_item) == type(0)) or (type(list_item) == type(u"")):
            if (type(list_item) == type("")) or (type(list_item) == type(0)) or (type(list_item) == type(1310039644165)) or (type(list_item) == type(u"")):
                # If we have a single fuzzcase then insert or if we have a list
                # create a batch

                if type(self.fuzzstr) == type([]):
                    fuzzbatch = []
                    for fuzz in self.fuzzstr:

                        i = listobj.index(list_item)
                        if self.append == 1:
                            fuzzedobj = copy.deepcopy(listobj)
                            fuzzedobj[i] = str(listobj[i]) + urllib.unquote(fuzz)
                            fuzzbatch.append(fuzzedobj)
                        if self.replace == 1:
                            fuzzedobj = copy.deepcopy(listobj)
                            fuzzedobj[i] = urllib.unquote(fuzz)
                            fuzzbatch.append(fuzzedobj)
                        #fuzzbatch.append(fuzzedobj)
                    fuzzed_db.append(fuzzbatch)

                if type(self.fuzzstr) == type(""):

                    i = listobj.index(list_item)
                    if self.append == 1:
                        fuzzedobj = copy.deepcopy(listobj)
                        fuzzedobj[i] = str(listobj[i]) + urllib.unquote(self.fuzzstr)
                        fuzzed_db.append(fuzzedobj)
                    if self.replace == 1:
                        fuzzedobj = copy.deepcopy(listobj)
                        fuzzedobj[i] = urllib.unquote(self.fuzzstr)
                        fuzzed_db.append(fuzzedobj)

                    #fuzzed_db.append(fuzzedobj)
                

            # If we encounter a dict within the list
            if type(list_item) == type({}):
                fuzzed_dict_items = self.fuzz_pyjason(list_item)
                for fuzzed_dict_item in fuzzed_dict_items:
                    # If a list was returned for each case we are using batches
                    if type(fuzzed_dict_item) == type([]):
                        fuzzbatch = []
                        for fuzzcase in fuzzed_dict_item:
                            fuzzedobj = copy.deepcopy(listobj)
                            i = listobj.index(list_item)
                            fuzzedobj[i] = fuzzcase
                            fuzzbatch.append(fuzzedobj)
                        fuzzed_db.append(fuzzbatch)
                    elif type(fuzzed_dict_item) == type({}):
                        fuzzedobj = copy.deepcopy(listobj)
                        i = listobj.index(list_item)
                        fuzzedobj[i] = fuzzed_dict_item
                        fuzzed_db.append(fuzzedobj)

            # If we encounter a list within the list
            if type(list_item) == type([]):
                #print "list in a list"
                fuzzed_list_items = self._fuzz_list(list_item)
                for fuzzed_list_item in fuzzed_list_items:
                    if (type(self.fuzzstr) == type([])) and (type(fuzzed_list_item[0])==type([])):
                        fuzzbatch = []
                        # Since we have used fuzz batches we have multi responses
                        for fuzzcase in fuzzed_list_item:
                            fuzzedobj = copy.deepcopy(listobj)
                            i = listobj.index(list_item)
                            fuzzedobj[i] = fuzzcase
                            fuzzbatch.append(fuzzedobj)
                        fuzzed_db.append(fuzzbatch)
                    else:
                        fuzzedobj = copy.deepcopy(listobj)
                        i = listobj.index(list_item)
                        fuzzedobj[i] = fuzzed_list_item
                        fuzzed_db.append(fuzzedobj)

        return fuzzed_db


    def fuzz_pyjason(self,dictobj):
        "Called by class constructor to parse and fuzz JSON data"
        fuzzed_db = []

        # Check to see if this  is a dict obj first if not then send to _fuzz_list to start
        if type(dictobj) == type([]):
            db = self._fuzz_list(dictobj)
            return db
            
        
        for param,value in dictobj.items():
            # If we have a fuzzable item such as a string/unicode or an int
            if (type(value) == type("")) or (type(value) == type(0)) or (type(value) == type(1310039644165)) or (type(value) == type(u"")):

                # If we have a single fuzzcase then insert or if we have a list
                # create a batch
                
                if type(self.fuzzstr) == type([]):
                    fuzzbatch = []
                    for fuzz in self.fuzzstr:

                        if self.append == 1:
                            fuzzedobj = copy.deepcopy(dictobj)
                            fuzzedobj[param] = str(value) + urllib.unquote(fuzz)
                            fuzzbatch.append(fuzzedobj)
                        if self.replace ==1:
                            fuzzedobj = copy.deepcopy(dictobj)
                            fuzzedobj[param] = urllib.unquote(fuzz)
                            fuzzbatch.append(fuzzedobj)
                        #fuzzbatch.append(fuzzedobj)
                    fuzzed_db.append(fuzzbatch)

                if type(self.fuzzstr) == type(""):
                    
                    if self.append == 1:
                        fuzzedobj = copy.deepcopy(dictobj)
                        fuzzedobj[param] = str(value) + urllib.unquote(self.fuzzstr)
                        fuzzed_db.append(fuzzedobj)
                    if self.replace == 1:
                        fuzzedobj = copy.deepcopy(dictobj)
                        fuzzedobj[param] = urllib.unquote(self.fuzzstr)
                        fuzzed_db.append(fuzzedobj)
                    #fuzzed_db.append(fuzzedobj)

            if type(value) == type([]):
                fuzzed_list_items = self._fuzz_list(value)
                for fuzzed_list_item in fuzzed_list_items:
                    #print type(fuzzed_list_item)
                    #print "item",fuzzed_list_item
                    if (type(self.fuzzstr) == type([])) and (type(fuzzed_list_item[0])==type([])):
                        fuzzbatch = []
                        # Since we have used fuzz batches we have multi responses
                        for fuzzcase in fuzzed_list_item:
                            fuzzedobj = copy.deepcopy(dictobj)
                            fuzzedobj[param] = fuzzcase
                            fuzzbatch.append(fuzzedobj)
                        fuzzed_db.append(fuzzbatch)
                    else:
                        fuzzedobj = copy.deepcopy(dictobj)
                        fuzzedobj[param] = fuzzed_list_item
                        fuzzed_db.append(fuzzedobj)

            # If we encounter a dict within the json obj
            if type(value) == type({}):
                # Fuzz the dict and then incorporate back in
                fuzzed_dict_items = self.fuzz_pyjason(value)
                for fuzzed_dict_item in fuzzed_dict_items:
                    # See if we have a single fuzz case or a batch
                    if type(fuzzed_dict_item) == type({}):
                        fuzzedobj = copy.deepcopy(dictobj)
                        fuzzedobj[param] = fuzzed_dict_item
                        fuzzed_db.append(fuzzedobj)
                    # If we are using fuzz batches (e.g. when fuzzing blind sql)
                    # then we need to collect in batches
                    elif type(fuzzed_dict_item) == type([]):
                        fuzzbatch = []
                        
                        for fuzzcase in fuzzed_dict_item:
                            fuzzedobj = copy.deepcopy(dictobj)
                            fuzzedobj[param] = fuzzcase
                            fuzzbatch.append(fuzzedobj)
                        fuzzed_db.append(fuzzbatch)

        #if len(fuzzed_db) ==0:
        #    fuzzed_db.append(dictobj)

        return fuzzed_db



if __name__ == "__main__":

    
    testjson ='{"d":[{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Spouse","value":"S","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Civil Partner","value":"J","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Common Law Partner/Cohabitee","value":"W","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Son/Daughter","value":"O","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Parent","value":"M","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Other Family","value":"F","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Employee","value":"E","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Employer","value":"B","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Business Partner","value":"C","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Other","value":"U","isDefaultValue":false},{"__type":"AjaxControlToolkit.CascadingDropDownNameValue","name":"Brother/Sister","value":"R","isDefaultValue":false}]}'
    testjson ='{"x":"hellodave","config":[{"A":"B"},"X",{"x":"y"}]}'
    #testjson ='{"x":"hellodave","config":{"a":{"x":"y"}}}'
    #testjson ='{"x":false,"config":true}'
    testjson ='[{"max_wait":30,"versions":[],"refid":1,"command":"wait_diff"}]'
    #(self,fuzzstr,jsonstr,append=1,replace=0):
    
    fuzzer = JsonFuzzer(testjson,"' or 1=1--")
    
    #fuzzer = JsonFuzzer(testjson,["' or 1=1--","' or 1=2--"],append=0,replace=1)
    x = fuzzer.fuzzed_json
    for y in x:
        for a in y:
            print a