#! /usr/bin/python
__author__="garyoleary"
__date__ ="$11-Aug-2011 09:23:35$"

import threading
import time
import Queue


class ThreadDispatcher():
    def __init__(self,*args,**kargs):
        self.max_threads=kargs.get("max_threads",20)
        print "[i] Setting Thread Count:{0}".format(self.max_threads)
        # Store the return value within self.return_queue. Set to 0 to disable
        self.store_return=kargs.get("store_return",1)
        self.semaphore = threading.Semaphore(self.max_threads)
        self.threads = []
        self.call_queue = []
        self.return_queue = Queue.Queue()

        
    def add(self,function):
        self.call_queue.append(function)

    def __dispatch_threads(self):
        while True:
            # Check to see if all threads are used
            if len(self.call_queue) != 0:
                if self.semaphore._Semaphore__value !=0:
                    func = self.call_queue.pop()
                    thread = threading.Thread(target=self.__thread,args=(func,))
                    self.threads.append(thread)
                    thread.demon = True
                    thread.start()
                else:
                    # If all threads are taken
                    #print "Thread Q full"
                    time.sleep(2)
            else:
                break

    def __thread(self,func):
        try:
            # Acquire semaphore and execute fuction
            self.semaphore.acquire()
            if self.store_return ==1:
                result = func()
                if result:
                    self.return_queue.put(result)
            else:
                func()
                
        except Exception as err:
            print "[i] Thread Error",err
        finally:
            self.semaphore.release()


    def start(self):
        self.__dispatch_threads()
        for thread in self.threads: thread.join()



if __name__ == "__main__":
    numbers =[1,2,3,4,5,6,7,8,9,10]
    
    def factory(number):
        def printout():
            time.sleep(2)
            return number
        return printout
    
    t = ThreadDispatcher()
    for n in numbers:
        
        t.add(factory(n))

    t.start()

    for x in range(t.return_queue._qsize()):
        print t.return_queue.get()
        
    print "END"