//Unreal Tournament GetInfo (Linux Version)
//	by Auriemma Luigi (bugtest at sitoverde.com)

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>

#define BUFFSIZE	4096
#define PORT	7778
#define INFO	"\\info\\"
#define STATUS	"\\status\\"
#define CHZ	0x5c	//"\"
#define DELAY	200000	//200 ms

void error_handle(int err);
void show(unsigned char *buffer, char *header);

int main(int argc, char *argv[]) {
	setbuf(stdout, NULL);
	if(argc < 2) {
		printf("\nUsage: %s <host> [port(default %d)]\n", argv[0], PORT);
		exit(1);
	}

	unsigned char	buff[BUFFSIZE];
	struct	sockaddr_in peer;
	struct	hostent *hp;
	int	shandle,
		err,
		recvlen;

	if(inet_addr(argv[1]) == INADDR_NONE) {
                hp = gethostbyname(argv[1]);
		if(hp == 0) error_handle(-1);
                else peer.sin_addr = *((struct in_addr *)hp->h_addr);
        }
                else peer.sin_addr.s_addr = inet_addr(argv[1]);
	if(!argv[2]) peer.sin_port = htons(PORT);
		else peer.sin_port = htons(atoi(argv[2]));
	peer.sin_family = PF_INET;
	recvlen = sizeof(peer);

	shandle = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);

	memset(buff, 0x00, BUFFSIZE);
	err = sendto(shandle, INFO, sizeof(INFO), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	show(buff, "Information");

	usleep(DELAY);

	memset(buff, 0x00, BUFFSIZE);
	err = sendto(shandle, STATUS, sizeof(STATUS), 0, (struct sockaddr *)&peer, recvlen);
	error_handle(err);
	err = recvfrom(shandle, buff, BUFFSIZE, 0, (struct sockaddr *)&peer, &recvlen);
	error_handle(err);
	show(buff, "Status");

	close(shandle);

	printf("\n");
	return(0);
}

void error_handle(int err) {
	if(err < 0) {
		perror("\nError");
		exit(1);
	}
}

void show(unsigned char *buff, char *header) {
	int	j = 1;
	printf("\n\n---\n%s\n---", header);
	for(; *buff != '\0'; buff++) {
		if((*buff == CHZ) && (j == 1)) {
			printf("\n");
			j = 0;
			continue;
		}
		if((*buff == CHZ) && (j == 0)) {
			printf(":\t");
			j = 1;
			continue;
		}
		if(*buff != CHZ) printf("%c", *buff);
	}
}

