/*
 * omen  - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen  is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen  is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ncurses.h>

#include "conf.h"
#include "tls.h"

/* parse packet type (for TLS) and print info on the TLS Window
 * the flag "direction = 0 for C->S (color: blue)
 *                       1 for S->C (color: red)
 *
 * RETURN: the return value = 1 if no other TLS packet is in the
 * recv/send stream. if not return value is 0. (-1 if error)
 */
int parse_tls_pkt(struct cbcPadConf *conf, int direction)
{
  int i;
  int tls_size;

  /* init */
  tls_size = 0;

  if (direction == 0) {
    wattron(conf->tlsWin, COLOR_PAIR(COLOR_CYAN));
    wattron(conf->debugWin, COLOR_PAIR(COLOR_CYAN));
  }
  else {
    wattron(conf->tlsWin, COLOR_PAIR(COLOR_MAGENTA));
    wattron(conf->debugWin, COLOR_PAIR(COLOR_MAGENTA));
  }
  if (conf->pkt_data == conf->pkt_data_end -1) {
    wattron(conf->tlsWin, COLOR_PAIR(COLOR_RED));
  }
  
  wprintw(conf->tlsWin, "[C]");
  if (direction == 1)
    wprintw(conf->tlsWin, "<");
  else
    wprintw(conf->tlsWin, "-");
  for(i=0;i<conf->x/4-4-8;i++)
    wprintw(conf->tlsWin, "-");
  
  if ((conf->pkt[conf->offset+1] != 0x03) && (conf->pkt[conf->offset+2] != 0x01)) {
    wprintw(conf->tlsWin, "-[No TLS pkt]---");
    /* return -1 */
    tls_size = -1;
  }
  else {
    // wprintw(conf->debugWin, "TLS version: %x.%x;", conf->pkt[conf->offset+1], conf->pkt[conf->offset+2]);
    // wprintw(conf->debugWin, "TCPsize: %d ", conf->pkt_size);

    /* Record layer Size on 2 bytes */
    tls_size = 256*conf->pkt[conf->offset+3] + conf->pkt[conf->offset+4];
    // wprintw(conf->debugWin, "RLsize: %d\n", tls_size);
    
    /* Handshake packet 4B+12B */
    if (conf->pkt[conf->offset+0] == 0x16) {
      // wprintw(conf->debugWin, "Type of Handshake: 0x%x\n", conf->pkt[conf->offset+5]);
      wprintw(conf->tlsWin, "[HS]");
      
      /* HS: client Hello */
      if (conf->pkt[conf->offset+5] == 0x01) {
	wprintw(conf->tlsWin, "-[cliHello]-");
      }
      /* HS: server Hello */
      else if (conf->pkt[conf->offset+5] == 0x02) {
	wprintw(conf->tlsWin, "-[srvHello]-");
	/* we check encryption just the first time due to miss interpretation */
	if (conf->enc_ok != 1) {
	  wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	  wprintw(conf->debugWin, "Cipher:");
	  /* here we list only the CBC-SHA algorithms (weak) */
	  switch (conf->pkt[conf->offset+77]) {
	  case 0x07: wprintw(conf->debugWin, "TLS_RSA_WITH_IDEA_CBC_SHA\n"); conf->enc_ok = 1; break;
	  case 0x08: wprintw(conf->debugWin, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA\n"); conf->enc_ok = 1; break;
	  case 0x09: wprintw(conf->debugWin, "TLS_RSA_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0a: wprintw(conf->debugWin, "TLS_RSA_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0b: wprintw(conf->debugWin, "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0c: wprintw(conf->debugWin, "TLS_DH_DSS_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0d: wprintw(conf->debugWin, "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0e: wprintw(conf->debugWin, "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x0f: wprintw(conf->debugWin, "TLS_DH_RSA_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x10: wprintw(conf->debugWin, "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x11: wprintw(conf->debugWin, "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x12: wprintw(conf->debugWin, "TLS_DHE_DSS_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x13: wprintw(conf->debugWin, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x14: wprintw(conf->debugWin, "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x15: wprintw(conf->debugWin, "TLS_DHE_RSA_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x16: wprintw(conf->debugWin, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x19: wprintw(conf->debugWin, "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x1a: wprintw(conf->debugWin, "TLS_DH_anon_WITH_DES_CBC_SHA\n");conf->enc_ok = 1; break;
	  case 0x1b: wprintw(conf->debugWin, "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA\n");conf->enc_ok = 1;  break;
	  default:
	    conf->enc_ok = 0;
	    wprintw(conf->debugWin, "\n\n[E]:: NOT A CBC-SHA ENCRYPTION! :( quitting\n");
	    wprintw(conf->debugWin, "\n");
	    wrefresh(conf->debugWin);
	    return -1;
	    
	  }
	  wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
	}
      }
      /* HS: cipher exchange packet */
      else if (conf->pkt[conf->offset+5] == 0x10) {
	wprintw(conf->tlsWin, "-[CipherXch]");
      }

      /* HS: server Hello done */
      else if (conf->pkt[conf->offset+5] == 0x0e) {
        wprintw(conf->tlsWin, "-[HelloDone]");
      }

      /* HS: certificate */
      else if (conf->pkt[conf->offset+5] == 0x0b) {
        wprintw(conf->tlsWin, "-[SrvCert]--");
      }


      /* HS: others (Encrypted Handshake) */
      else {
	wprintw(conf->tlsWin, "-[Finished]-");
      }
    }
    /* Change Cipher Spec */
    else if(conf->pkt[conf->offset+0] == 0x14) {
      wprintw(conf->tlsWin, "[chngCipherSpec]");
    }
    
    /* Application data (the good packets!) */
    else if(conf->pkt[conf->offset+0] == 0x17) {
      conf->pkt_data++;
      wprintw(conf->tlsWin, "[App-Data]-[%2d]-", conf->pkt_data);
    }

    /* Alert pkt */
    else if(conf->pkt[conf->offset+0] == 0x15) {
      wprintw(conf->tlsWin, "[ALERT]---------");
    }
    
    /* others types of SSL/TLS packets */
    else {
      wprintw(conf->tlsWin, "-------[?]------");
    }
  }

  /* just for ncurses old school style */
  for(i=0;i<conf->x/4-4-10;i++)
    wprintw(conf->tlsWin, "-");
  if (direction == 0)
    wprintw(conf->tlsWin, ">");
  else
    wprintw(conf->tlsWin, "-");
  wprintw(conf->tlsWin, "[S]\n");

  wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
  wattron(conf->tlsWin, COLOR_PAIR(COLOR_WHITE));
  wrefresh(conf->tlsWin);
  wrefresh(conf->debugWin);
  
  /* parsing if other TLS packet in the stream data (5B: tls header) */
  conf->offset = conf->offset + tls_size + 5;
  if ((conf->offset == conf->pkt_size) || (tls_size == -1))
    return 1;
  else
    return 0;
  
}
