#pragma once

#include "FakeDelegateEntry.h"

using namespace System;
using namespace System::Runtime::Serialization;
using namespace System::Reflection;

[Serializable]
ref class FakeDelegate : public ISerializable
{
	FakeDelegateEntry^ _delegateEntry;
	array<MethodInfo^>^ _methods;

public:

	virtual void GetObjectData(SerializationInfo^ info, StreamingContext context)
	{
		Type^ t = Object::typeid->Assembly->GetType("System.DelegateSerializationHolder");

		info->SetType(t);

		// Alternatively use
		// info.AssemblyName = "mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
		// info.FullTypeName = "System.DelegateSerializationHolder";

		info->AddValue("Delegate", _delegateEntry);
		for (int i = 0; i < _methods->Length; ++i)
		{
			info->AddValue("method" + i, _methods[i]);
		}
	}

	FakeDelegate(FakeDelegateEntry^ delegateEntry, array<MethodInfo^>^ methods)
	{
		_delegateEntry = delegateEntry;
		_methods = methods;
	}
};

