package
{
  import flash.display.*;
  import flash.events.*;
  import flash.media.*;
  import flash.net.*;
  import flash.text.*;
  import mx.utils.*;

  public class PlayManifest extends Sprite
  {
    private var txt:TextField;
    private var source:AVSegmentedSource;
    private var stream:AVStream;
    private var video:StageVideo;

    public function PlayManifest():void
    {
      var url:String = stage.loaderInfo.url;
      var host:String = URLUtil.getServerName(url);
      var vars:URLVariables = new URLVariables(url.split('?')[1]);
      var file:String = vars.file;

      txt = new TextField();
      txt.width = 512;
      txt.height = 256;
      txt.x = 0;
      txt.y = 32;
      txt.autoSize = "left";
      addChild(txt);

      txt.appendText("Starting....\n");
      txt.appendText("num stageVideos: " + stage.stageVideos.length + "\n");

      //video = stage.stageVideos[0];
      source = new AVSegmentedSource();
      txt.appendText("Got source....\n");
      stream = new AVStream(source);
      txt.appendText("Got stream....\n");
      source.addEventListener(AVStatusEvent.AV_STATUS, statusHandler);
      stream.addEventListener(AVStatusEvent.AV_STATUS, statusHandler);
      source.load("http://" + host + "/" + file, AVSegmentedSource.DASH);
    }

    private function statusHandler(event:AVStatusEvent):void
    {
      txt.appendText("Event: " + event.result + ", " + event.notificationType + ", " + event.description + ", " + event + "\n");
      if (event.notificationType == AVStatusEvent.MANIFEST_UPDATE) {
        txt.appendText("Track count: " + source.getTrackCount(0, AVSegmentedSource.VIDEO) + "\n");
        txt.appendText("Attaching...\n");
        //video.attachAVStream(stream);
        txt.appendText("Fast forwarding....\n");
        stream.fastForward(0.5);  // play() doesn't seem to parse the mp4.
      }
    }
  }
}
