#include <winsock.h>
#include <string.h>

#include "serv.h"

bool serveur::createsocket()
{
	if (create)
		return 0;
	sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(sock <0)
	{
		create = 0;
		return 0;
	};
	create = 1;
	return sock;
}

bool serveur::listen(unsigned short port, unsigned int nbwaitconnect)
{
	int test;
	memset(&mysock, 0, sizeof(mysock));
	mysock.sin_family = AF_INET ;
	mysock.sin_addr.s_addr = htonl(INADDR_ANY);
	mysock.sin_port = htons(port);
	test = bind(sock,(sockaddr *) &mysock,sizeof(mysock));
	if (test <0)
	{
		closesock();
		return 0;
	};
	listen(sock,nbwaitconnect);
	return 1;
}

serveur * serveur::waitconnect()
{
	struct sockaddr_in astruct;
	int taille;
	int asock;
	serveur * newsock ;
	taille = sizeof(astruct);
	asock = accept(sock, (sockaddr *) &astruct,&taille);
	newsock = new serveur ;
	newsock->createbytheclass(asock,astruct);
	return newsock;
}

bool serveur::connectsocket(char *dns,unsigned short port)
{
	struct hostent *hoste;
	int test;
	memset(&mysock, 0, sizeof(mysock));
	if(!(hoste = gethostbyname(dns)))
		mysock.sin_addr.s_addr = inet_addr(dns);
	else
		memcpy(&(mysock.sin_addr),hoste->h_addr,hoste->h_length);
	mysock.sin_family = AF_INET ;
	mysock.sin_port = htons(port);
	test = connect(sock,(struct sockaddr *) &mysock , sizeof(mysock));
	if(test <0)
		return 0;
	connected = 1;
	return 1;
};

bool serveur::socketsend(char *envoi)
{
	int veri;
	int taiverif;
	if(!connected)
		return 0;
	veri = strlen(envoi);
	taiverif = send(sock,envoi,veri,0);
	if(veri != taiverif)
	{
		connected = 0;
		return 0;
	};
	return 1;
}

bool serveur::getline(char buf[],unsigned int maxcara)
{
	unsigned int testing;
	unsigned int curseur;
	char recoi;
	if(!connected)
		return 0;
	curseur = 0;
	do{
		testing = recv(sock,&recoi,sizeof(char),0);
		if(testing != sizeof(char))
		{
			buf[curseur] = '\0' ;
			connected = 0;
			return 0;
		};
		if( curseur == maxcara)
		{
			buf[curseur] = '\0';
		};
		if ((curseur < maxcara)&&(recoi != '\r')&&(recoi != '\n'))
		{
			buf[curseur] = recoi ;
			curseur++ ;
		};
	}while(recoi != '\n' );
	buf[curseur] = '\0' ;
	return 1;
}

bool serveur::getline(char buf2[])
{
	return getline(buf2,maxread);
}

bool serveur::getword(char in[],unsigned int max)
{
	int testing;
	unsigned int curseur;
	char recoi;
	if(!connected)
		return 0;
	curseur = 0;
	do{
		testing = recv(sock,&recoi,sizeof(char),0);
		if(testing != sizeof(char))
		{
			in[curseur] = '\0' ;
			connected = 0;
			return 0;
		};
		if( curseur == max)
		{
			in[curseur] = '\0';
		};
		if ((curseur < max)&&(recoi != '\r')&&(recoi != '\n')&&(recoi != ' '))
		{
			in[curseur] = recoi ;
			curseur++ ;
		};
	}while((recoi != '\n') && (recoi != ' '));
	in[curseur] = '\0' ;
	return 1;
}

bool serveur::getword(char in2[])
{
	return getword(in2,maxread);
}

bool serveur::ifgetchar(char *caraif)
{
	fd_set fdens;
	struct timeval tv;
	tv.tv_sec = seconde ;
	tv.tv_usec = microseconde ;
	FD_ZERO(&fdens);
	FD_SET(sock,&fdens);
	select(sock+1, &fdens, NULL, NULL, &tv);
	if(FD_ISSET(sock,&fdens))
	{
		if(!getnb(caraif,sizeof(char)))
			closesock();
		return 1;
	}
	else
	{
		return 0;
	};
}

bool serveur::ifchargetnb(char ligne[],unsigned int aumax)
{
	bool retour;
	retour = ifgetchar(ligne) ;
	if(retour)
	{
		connected = getnb(ligne,aumax) ;
	};
	return retour;
}

bool serveur::ifchargetline(char ligne[],unsigned int lemax)
{
	bool retour;
	retour = ifgetchar(ligne) ;
	if(retour)
	{
		if(*ligne == '\n')
		{
			*ligne = '\0';
			return 1;
		};
		if(*ligne != '\r')
			ligne++;
		connected = getline(ligne,lemax) ;
	};
	return retour;
}

bool serveur::ifchargetline(char ligne[])
{
	return ifchargetline(ligne,maxread);
}

bool serveur::getnb(char *vect,unsigned int nb)
{
	unsigned int testing;
	unsigned int curseur;
	char recoi;
	if(!connected)
		return 0;
	curseur = 0;
	do{
		testing = recv(sock,&recoi,sizeof(char),0);
		if(testing != sizeof(char))
		{
			vect[curseur] = '\0' ;
			connected = 0;
			return 0;
		};
		if( curseur == nb)
		{
			vect[curseur] = '\0';
		};
		if (curseur < nb)
		{
			vect[curseur] = recoi ;
			curseur++ ;
		};
	}while(curseur < nb);
	return 1;
}

bool serveur::sendnb(char *vec,unsigned int longueur)
{
	int taiverif;
	if(!connected)
		return 0;
	taiverif = send(sock,vec,longueur,0);
	if((int)longueur != taiverif)
	{
		connected = 0;
		return 0;
	};
	return 1;
}

int serveur::getnumsock()
{
	return sock;
}

bool serveur::createbytheclass(int thesock,struct sockaddr_in thestruct)
{
	if(create)
		return 0;
	sock = thesock ;
	memcpy(&mysock,&thestruct,sizeof(thestruct));
	create = 1;
	connected = 1;
	return 1;
}

void serveur::closesock()
{
	if(create) 
	{
		closesocket(sock);
		create = 0;
		connected = 0;
	};
}

bool serveur::isconnect()
{
	return connected;
}

void serveur::operator << (char *chaine)
{
	socketsend(chaine);
}

void serveur::operator >> (char *read)
{
	getword(read);
}

serveur::serveur()
{
	connected = 0;
	create = 0 ;
	maxread = 0xFFFFFFFF ;
	seconde = 0;
	microseconde = 0;
	createsocket();
}

serveur::~serveur()
{
	if(connected)
		closesock();
}
