/**
*
* GoGoGadget - kernel exploitation helper class
*
* Copyright (c) 2016 ReWolf
* http://blog.rewolf.pl/
* http://blog.rewolf.pl/blog/?p=1739
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/
#include <Windows.h>
#include <winternl.h>
#include <TlHelp32.h>
#include <algorithm>
#include <iterator>
#include "GoGoGadget.h"

GoGoGadget::GoGoGadget()
{
	char tmpEnviron[256] = { 0 };
	GetEnvironmentVariableA("SystemRoot", tmpEnviron, sizeof(tmpEnviron));
	m_systemRoot = tmpEnviron;
	createPidNameMapping();
}

std::string GoGoGadget::convertNtPath(char* path) const
{
	if (_strnicmp(path, "\\SystemRoot\\", sizeof("\\SystemRoot\\") - 1) == 0)
	{
		return m_systemRoot + "\\" + (path + sizeof("\\SystemRoot\\") - 1);
	}
	else
		return path;
}

void GoGoGadget::applyPERelocations(uint8_t* module, uint64_t imageBase)
{
	struct Reloc
	{
		uint16_t offset : 12;
		uint16_t type : 4;
	};
	// no sanity checks, beware!
	IMAGE_DOS_HEADER* dosHdr = (IMAGE_DOS_HEADER*)module;
	IMAGE_NT_HEADERS64* ntHdr = (IMAGE_NT_HEADERS64*)(module + dosHdr->e_lfanew);
	DWORD oldProt;
	VirtualProtect(module, ntHdr->OptionalHeader.SizeOfImage, PAGE_READWRITE, &oldProt);
	if (0 != ntHdr->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress)
	{
		void* maxAddr = module + ntHdr->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress + ntHdr->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].Size;
		IMAGE_BASE_RELOCATION* reloc = (IMAGE_BASE_RELOCATION*)(module + ntHdr->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC].VirtualAddress);
		while (reloc < maxAddr)
		{
			Reloc* r = (Reloc*)(reloc + 1);
			for (int i = 0; i < (reloc->SizeOfBlock - sizeof(IMAGE_BASE_RELOCATION)) / sizeof(Reloc); i++)
			{
				switch (r[i].type)
				{
					case IMAGE_REL_BASED_DIR64:
					{
						*(uint64_t*)(module + reloc->VirtualAddress + r[i].offset) -= ntHdr->OptionalHeader.ImageBase;
						*(uint64_t*)(module + reloc->VirtualAddress + r[i].offset) += imageBase;
					}
					break;
					case IMAGE_REL_BASED_ABSOLUTE: break;
					default:
						printf("unkown reloc: %d %d\n", r[i].type, r[i].offset);
				}
			}
			reloc = (IMAGE_BASE_RELOCATION*)((uint8_t*)reloc + reloc->SizeOfBlock);
		}
	}
	VirtualProtect(module, ntHdr->OptionalHeader.SizeOfImage, oldProt, &oldProt);
}

bool GoGoGadget::iterateExecutableNonDiscardableSections(uint8_t* module, uint64_t imageBase, std::function<bool(uint64_t base, uint8_t* ptr, size_t size)> f)
{
	applyPERelocations(module, imageBase);
	// no sanity checks, beware!
	IMAGE_DOS_HEADER* dosHdr = (IMAGE_DOS_HEADER*)module;
	IMAGE_NT_HEADERS64* ntHdr = (IMAGE_NT_HEADERS64*)(module + dosHdr->e_lfanew);
	IMAGE_SECTION_HEADER* sections = IMAGE_FIRST_SECTION(ntHdr);
	for (int i = 0; i < ntHdr->FileHeader.NumberOfSections; i++)
	{
		if (sections[i].Characteristics & (IMAGE_SCN_MEM_EXECUTE | IMAGE_SCN_CNT_CODE))
		{
			if (!(sections[i].Characteristics & IMAGE_SCN_MEM_DISCARDABLE))
			{
				if (f(imageBase + sections[i].VirtualAddress, module + sections[i].VirtualAddress, sections[i].SizeOfRawData))
					return true;
			}
		}
	}
	return false;
}

void GoGoGadget::resolveExports(std::string& moduleName, uint8_t* module, uint64_t imageBase, const std::vector<std::pair<std::string, std::string>>& apiNames)
{
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  