import sys
import socket
import fcntl
import struct
import array

class SystemInfo:
    
    def __init__(self):
        self.interfaces = self.get_all_interfaces()
	self.loopback_addr = self.interfaces[0][1]
    
    @staticmethod
    def get_all_interfaces():
        is_64bits = sys.maxsize > 2**32
        struct_size = 40 if is_64bits else 32
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        max_possible = 8 # initial value
        while True:
            bytes = max_possible * struct_size
            names = array.array('B', '\0' * bytes)
            outbytes = struct.unpack('iL', fcntl.ioctl(
                s.fileno(),
                0x8912,  # SIOCGIFCONF
                struct.pack('iL', bytes, names.buffer_info()[0])
            ))[0]
            if outbytes == bytes:
                max_possible *= 2
            else:
                break
        namestr = names.tostring()
        return [(namestr[i:i+16].split('\0', 1)[0],
                 socket.inet_ntoa(namestr[i+20:i+24]))
                for i in range(0, outbytes, struct_size)]

