#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "include.h"
#include "getput.h"
#include "cipher.h"


extern void fatal(char*, ...);
extern unsigned long crc32(const unsigned char*, unsigned int); 


unsigned char read_char (int sock)
{
  int ret;
  unsigned char i;
  
  
	ret = read(sock, &i, 1);
	if (ret == 0 || ret < 0) fatal("SERVER_CLOSED_SESSION CRASHED???");
	return(i);

}

unsigned long read_long (int sock)
{
  int ret;
  unsigned long tmp;
  unsigned char buffer[4];


	ret = read(sock, buffer, 4);
	if (ret == 0 || ret < 0) fatal("SERVER_CLOSED_SESSION CRASHED??? ");
	tmp = GET_32BIT(buffer);
	return(tmp);

}

void write_long (int sock, unsigned int value)
{
  int ret;
  unsigned char buffer[4];


	PUT_32BIT(buffer, value);
	ret = write(sock, buffer, 4);
	if (ret == 0 || ret < 0) fatal("SERVER_CLOSED_SESSION CRASHED??? ");
	return;

}


unsigned char read_packet(BUFFER *input, int sock)
{
  unsigned char *buffer, type;
  unsigned long checksum, sum;
  unsigned long packetlen, padded_len;
  int ret;
  


    input->start = input->src;
    buffer	 = input->start;


    packetlen = read_long(sock);
    if (packetlen < 1 + 2 + 2 || packetlen > 256 * 1024)
	fatal("invalid packet length %d", packetlen);
    padded_len = (packetlen + 8) & ~7;
    ret = read(sock, buffer, padded_len);


//    printf("---received %d bytes, accepted %d\n", ret, (int)padded_len);  


    if (ret == 0 || ret < 0) fatal("read_packet:read");
    if ((unsigned int) ret != padded_len)
	fatal("except:%d bytes, got %d bytes", padded_len, ret);



    if (input->cipher != SSH_CIPHER_NONE)
    {
	cipher_decrypt(input->cipher, buffer, padded_len);
    }


    checksum = crc32(buffer, padded_len - 4);
    sum      = GET_32BIT(buffer + padded_len - 4);

	
    if (checksum != sum) fatal("CRC-32: expect:%x got:%x", sum, checksum);


//-- CAT CRC-32 and padding

    input->start = buffer + (8 - packetlen % 8);
    input->end   = input->start + (padded_len - 4);

    memcpy(input->src, input->start, padded_len - 4);
    input->start = input->src;
    input->end	 = input->start + padded_len - 4;
    
//-- DECOMPRESSION --


    type = (unsigned char) input->start[0];
    input->start ++;

    if(type == SSH_MSG_DISCONNECT)
      {
        word32 len;
	
	    printf("server disconnected!!!\n");
	    len = GET_32BIT(input->start);
	    PUT_32BIT(input->start + 4 + len, 0);
	    fatal("%s", input->start+4);
      }

    return(type);
}

unsigned char write_packet(BUFFER *input, int sock)
{
  char *buf;
  int padding, ret;
  unsigned long checksum, inputlen, len;
  

    inputlen = input->end - input->start;


    buf = malloc(inputlen + 24);
    if (!buf) fatal("write_packet: malloc");


    len = inputlen + 4;
    padding = 8 - (len % 8 );


    memcpy(buf + padding, input->start, inputlen);
    checksum = crc32(buf, padding + inputlen);
    PUT_32BIT(buf + padding + inputlen, checksum);


//-- ENCRYPTION --


    if (input->cipher != SSH_CIPHER_NONE)
    {
	cipher_encrypt(input->cipher, buf, (len + 8) & ~7);
    }


    write_long(sock, len);
    ret = write(sock, buf, (len + 8) & ~7);

//    printf("---sent packet:%d bytes long\n", (unsigned int) ret);
    free(buf);
    return(ret);
}


void hack_packet(BUFFER *input, int sock)
{
  char *buf;
  unsigned long len, ret;
  

    len = input->end - input->start;
    buf = input->start;


    write_long(sock, len);
    ret = write(sock, buf, (len + 8) & ~7);

    printf("---sent packet:%u bytes long\n", (unsigned int) ret);
    return;
}

void packet_start (BUFFER *buffer, unsigned char type)
{
    buffer->start = buffer->src;
    buffer->end   = buffer->src;
    
    memset(buffer->end, type, 1);
    buffer->end ++;
}

