/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package smbtest;

import java.util.concurrent.SynchronousQueue;
import jcifs.Config;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;

/**
 *
 * @author dev
 */
public class SmbRequestThread extends Thread {
    
    SynchronousQueue<byte[]> _queue;
    
    public SmbRequestThread(SynchronousQueue<byte[]> queue) {
        _queue = queue;
    }
    
    @Override
    public void run() {
        try {
            Config.setNtlmContextFactory((auth, doSigning) -> 
                    new QueuedNtlmContext((SynchronousQueue<byte[]>)
                            auth.additionalData));

            NtlmPasswordAuthentication auth = 
                new NtlmPasswordAuthentication(".", "", ""); 
            auth.additionalData = _queue;
            SmbFile f = new SmbFile("smb://127.0.0.1/C$/dummy.txt", auth);
            
            SmbFileOutputStream os = new SmbFileOutputStream(f);
            os.write("Hello World!".getBytes());
            os.close();            
        } catch(Throwable e) {
            e.printStackTrace(System.out);
        }
        
        System.out.println("Done");
        System.exit(0);
    }
}
