#The number of entries in the first-level translation table
NUM_FIRST_LEVEL_ENTRIES = 1024

#The number of entries in the second-level translation table
NUM_SECOND_LEVEL_ENTRIES = 512

#The number of entries in the third-level translation table
NUM_THIRD_LEVEL_ENTRIES = 512

#The size of the physical address range
PHYS_ADDR_SIZE = 2**40

#The offset of the S2AP bits in the lower block attributes
S2AP_BIT_OFFSET = 6

#The offset of the XN bit in the upper block attributes
XN_BIT_OFFSET = 54

#The mask used to retrieve the OA from a first-level descriptor
FLD_BLOCK_OA_MASK = 0xFFFFC0000000

#The mask used to retrieve the OA from a second-level descriptor
SLD_BLOCK_OA_MASK = 0xFFFFFFE00000

#The mask used to retrieve the OA from a third-level descriptor
TLD_BLOCK_OA_MASK = 0xFFFFFFFFF000

#The mask used to retrieve the OA (for the next-level table) from a table descriptor
TABLE_OA_MASK = 0xFFFFFFFFF000

#The number of bytes in a QWORD
QWORD_SIZE = 8
